/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.processor;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.SAMLTokenPrincipal;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.WSUsernameTokenPrincipal;
import org.apache.ws.security.cache.ReplayCache;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.message.token.UsernameToken;
import org.apache.ws.security.processor.Processor;
import org.apache.ws.security.validate.Credential;
import org.apache.ws.security.validate.Validator;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsernameTokenProcessor
implements Processor {
    private static Log log = LogFactory.getLog(UsernameTokenProcessor.class);

    @Override
    public List<WSSecurityEngineResult> handleToken(Element elem, RequestData data, WSDocInfo wsDocInfo) throws WSSecurityException {
        String id;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Found UsernameToken list element");
        }
        if (!"".equals(id = elem.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id"))) {
            Element foundElement = wsDocInfo.getTokenElement(id);
            if (elem.equals(foundElement)) {
                WSSecurityEngineResult result = wsDocInfo.getResult(id);
                return Collections.singletonList(result);
            }
            if (foundElement != null) {
                throw new WSSecurityException(4, "duplicateError");
            }
        }
        Validator validator = data.getValidator(WSSecurityEngine.USERNAME_TOKEN);
        Credential credential = this.handleUsernameToken(elem, validator, data);
        UsernameToken token = credential.getUsernametoken();
        int action = 1;
        byte[] secretKey = null;
        if (token.getPassword() == null) {
            action = 8192;
            if (token.isDerivedKey()) {
                token.setRawPassword(data);
                secretKey = token.getDerivedKey();
            }
        }
        WSSecurityEngineResult result = new WSSecurityEngineResult(action, token);
        result.put("id", token.getID());
        result.put("secret", secretKey);
        if (validator != null) {
            result.put("validated-token", Boolean.TRUE);
            if (credential.getTransformedToken() != null) {
                result.put("transformed-token", credential.getTransformedToken());
                SAMLTokenPrincipal samlPrincipal = new SAMLTokenPrincipal(credential.getTransformedToken());
                result.put("principal", samlPrincipal);
            } else {
                WSUsernameTokenPrincipal principal = new WSUsernameTokenPrincipal(token.getName(), token.isHashed());
                principal.setNonce(token.getNonce());
                principal.setPassword(token.getPassword());
                principal.setCreatedTime(token.getCreated());
                principal.setPasswordType(token.getPasswordType());
                result.put("principal", principal);
            }
            result.put("subject", credential.getSubject());
        }
        wsDocInfo.addTokenElement(elem);
        wsDocInfo.addResult(result);
        return Collections.singletonList(result);
    }

    private Credential handleUsernameToken(Element token, Validator validator, RequestData data) throws WSSecurityException {
        boolean allowNamespaceQualifiedPasswordTypes = false;
        boolean bspCompliant = true;
        WSSConfig wssConfig = data.getWssConfig();
        int utTTL = 300;
        int futureTimeToLive = 60;
        if (wssConfig != null) {
            allowNamespaceQualifiedPasswordTypes = wssConfig.getAllowNamespaceQualifiedPasswordTypes();
            bspCompliant = wssConfig.isWsiBSPCompliant();
            utTTL = wssConfig.getUtTTL();
            futureTimeToLive = wssConfig.getUtFutureTTL();
        }
        UsernameToken ut = new UsernameToken(token, allowNamespaceQualifiedPasswordTypes, bspCompliant);
        ReplayCache replayCache = data.getNonceReplayCache();
        if (replayCache != null && ut.getNonce() != null) {
            if (replayCache.contains(ut.getNonce())) {
                throw new WSSecurityException(3, "badUsernameToken", new Object[]{"A replay attack has been detected"});
            }
            Date created = ut.getCreatedDate();
            if (created == null || utTTL <= 0) {
                replayCache.add(ut.getNonce());
            } else {
                replayCache.add(ut.getNonce(), (long)utTTL + 1L);
            }
        }
        if (!ut.verifyCreated(utTTL, futureTimeToLive)) {
            throw new WSSecurityException(8);
        }
        Credential credential = new Credential();
        credential.setUsernametoken(ut);
        if (validator != null) {
            return validator.validate(credential, data);
        }
        return credential;
    }
}

