/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.crypto;

import com.netapp.crypto.KeyStoreWrapper;
import com.netapp.crypto.SymmetricCipherDelegate;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.SecretKey;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
class KeyRotator {
    private static final String KEY_ALIAS_FORMAT = "key_%s_%s";
    private static final Pattern KEY_ALIAS_PATTERN = Pattern.compile(String.format("key_%s_%s", "(\\d+)", "(\\d+)"));
    private final KeyStoreWrapper keyStoreWrapper;
    private SymmetricCipherDelegate cipherDelegate;
    private KeyEntry currentKeyEntry;
    private Map<Long, KeyEntry> cachedKeyEntries = new HashMap<Long, KeyEntry>();

    KeyRotator(KeyStoreWrapper keyStoreWrapper, SymmetricCipherDelegate cipherDelegate) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        this.keyStoreWrapper = keyStoreWrapper;
        this.cipherDelegate = cipherDelegate;
        this.initializeCurrentKeyEntry();
    }

    private synchronized void initializeCurrentKeyEntry() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException {
        long maxKeyIndex = -1L;
        Enumeration<String> e = this.keyStoreWrapper.aliases();
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            Long keyIndex = this.getKeyIndex(alias);
            if (keyIndex == null) continue;
            maxKeyIndex = Math.max(keyIndex, maxKeyIndex);
        }
        if (maxKeyIndex == -1L) {
            this.generateNextKey();
        } else {
            this.currentKeyEntry = this.getKey(maxKeyIndex);
        }
    }

    private Long getKeyIndex(String alias) {
        Matcher matcher = KEY_ALIAS_PATTERN.matcher(alias);
        if (matcher.matches() && Integer.parseInt(matcher.group(1)) == this.cipherDelegate.getId()) {
            return Long.valueOf(matcher.group(2));
        }
        return null;
    }

    private String getKeyAlias(long index) {
        return String.format(KEY_ALIAS_FORMAT, this.cipherDelegate.getId(), index);
    }

    public synchronized KeyEntry getCurrentKey() {
        return this.currentKeyEntry;
    }

    public synchronized KeyEntry getKey(long index) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException {
        KeyEntry keyEntry = this.cachedKeyEntries.get(index);
        if (keyEntry == null) {
            keyEntry = new KeyEntry(index, (SecretKey)this.keyStoreWrapper.getKey(this.getKeyAlias(index)));
            this.cachedKeyEntries.put(index, keyEntry);
        }
        return keyEntry;
    }

    public synchronized void generateNextKey() throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        String nextCurrentKeyAlias = this.generateNextKeyAlias();
        SecretKey nextCurrentKey = this.cipherDelegate.generateKey();
        this.keyStoreWrapper.setKeyEntry(nextCurrentKeyAlias, nextCurrentKey);
        this.currentKeyEntry = new KeyEntry(this.getKeyIndex(nextCurrentKeyAlias), nextCurrentKey);
        this.cachedKeyEntries.put(this.currentKeyEntry.getIndex(), this.currentKeyEntry);
    }

    private synchronized String generateNextKeyAlias() {
        if (this.currentKeyEntry == null) {
            return this.getKeyAlias(0L);
        }
        return this.getKeyAlias(this.currentKeyEntry.getIndex() + 1L);
    }

    public static final class KeyEntry {
        private final long index;
        private final SecretKey key;

        protected KeyEntry(long index, SecretKey key) {
            this.index = index;
            this.key = key;
        }

        public long getIndex() {
            return this.index;
        }

        public SecretKey getKey() {
            return this.key;
        }
    }
}

