/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.crypto;

import com.netapp.crypto.CryptoException;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.concurrent.Callable;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;

abstract class SymmetricCipherDelegate {
    private final int id;
    private final String cipherTransformation;
    private final int cipherIvBitLength;
    private final String keyGeneratorAlgorithm;
    private final int keyBitLength;
    private final ThreadLocal<SecureRandom> secureRandomLocal;
    private final ThreadLocal<Cipher> cipherLocal = new ThreadLocal<Cipher>(){

        @Override
        protected Cipher initialValue() {
            try {
                return Cipher.getInstance(SymmetricCipherDelegate.this.cipherTransformation);
            }
            catch (NoSuchAlgorithmException e) {
                throw new CryptoException(e);
            }
            catch (NoSuchPaddingException e) {
                throw new CryptoException(e);
            }
        }
    };
    private final ThreadLocal<KeyGenerator> keyGenerator = new ThreadLocal<KeyGenerator>(){

        @Override
        protected KeyGenerator initialValue() {
            try {
                KeyGenerator generator = KeyGenerator.getInstance(SymmetricCipherDelegate.this.keyGeneratorAlgorithm);
                generator.init(SymmetricCipherDelegate.this.keyBitLength, (SecureRandom)SymmetricCipherDelegate.this.secureRandomLocal.get());
                return generator;
            }
            catch (NoSuchAlgorithmException e) {
                throw new CryptoException(e);
            }
        }
    };

    protected SymmetricCipherDelegate(int id, String cipherTransformation, int cipherIvBitLength, String keyGeneratorAlgorithm, int keyBitLength, final Callable<SecureRandom> secureRandomFactory) {
        this.id = id;
        this.cipherTransformation = cipherTransformation;
        this.cipherIvBitLength = cipherIvBitLength;
        this.keyGeneratorAlgorithm = keyGeneratorAlgorithm;
        this.keyBitLength = keyBitLength;
        this.secureRandomLocal = new ThreadLocal<SecureRandom>(){

            @Override
            protected SecureRandom initialValue() {
                try {
                    return (SecureRandom)secureRandomFactory.call();
                }
                catch (Exception e) {
                    throw new CryptoException("Unable to create SecureRandom", e);
                }
            }
        };
    }

    public int getId() {
        return this.id;
    }

    protected Cipher getCipher() {
        return this.cipherLocal.get();
    }

    protected int getCipherIvBitLength() {
        return this.cipherIvBitLength;
    }

    protected KeyGenerator getKeyGenerator() {
        return this.keyGenerator.get();
    }

    protected SecureRandom getSecureRandom() {
        return this.secureRandomLocal.get();
    }

    public SecretKey generateKey() {
        return this.getKeyGenerator().generateKey();
    }

    public abstract byte[] encrypt(SecretKey var1, byte[] var2) throws InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, IOException;

    public abstract byte[] decrypt(SecretKey var1, byte[] var2) throws IllegalBlockSizeException, BadPaddingException, IOException, InvalidKeyException, InvalidAlgorithmParameterException;
}

