/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager.ldap;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import javax.net.ssl.SSLSocketFactory;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConst;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.Type;
import org.apache.qpid.server.security.auth.manager.ldap.AbstractLDAPSSLSocketFactory;
import org.apache.qpid.server.util.ServerScopedRuntimeException;

public class LDAPSSLSocketFactoryGenerator {
    static final String SSL_SOCKET_FACTORY_FIELD = "_sslSocketFactory";
    static final String TARGET_PACKAGE_NAME = LDAPSSLSocketFactoryGenerator.class.getPackage().getName();

    public static Class<? extends AbstractLDAPSSLSocketFactory> createSubClass(String simpleName, SSLSocketFactory sslSocketFactory) {
        String fqcn = TARGET_PACKAGE_NAME + "." + simpleName;
        byte[] classBytes = LDAPSSLSocketFactoryGenerator.createSubClassByteCode(fqcn);
        try {
            LDAPSSLSocketFactoryAwareDelegatingClassloader classLoader = new LDAPSSLSocketFactoryAwareDelegatingClassloader(fqcn, classBytes, sslSocketFactory);
            Class<?> clazz = classLoader.loadClass(fqcn);
            return clazz;
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalArgumentException("Could not resolve dynamically generated class " + fqcn, cnfe);
        }
    }

    private static byte[] createSubClassByteCode(String className) {
        ClassGen classGen = new ClassGen(className, AbstractLDAPSSLSocketFactory.class.getName(), "<generated>", 33, null);
        ConstantPoolGen constantPoolGen = classGen.getConstantPool();
        InstructionFactory factory = new InstructionFactory(classGen);
        LDAPSSLSocketFactoryGenerator.createSslContextStaticField(classGen, constantPoolGen);
        LDAPSSLSocketFactoryGenerator.createGetDefaultStaticMethod(classGen, constantPoolGen, factory);
        classGen.addEmptyConstructor(4);
        JavaClass javaClass = classGen.getJavaClass();
        ByteArrayOutputStream out = null;
        try {
            out = new ByteArrayOutputStream();
            javaClass.dump((OutputStream)out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException ioex) {
            throw new IllegalStateException("Could not write to a ByteArrayOutputStream - should not happen", ioex);
        }
        finally {
            LDAPSSLSocketFactoryGenerator.closeSafely(out);
        }
    }

    private static void createSslContextStaticField(ClassGen classGen, ConstantPoolGen constantPoolGen) {
        FieldGen fieldGen = new FieldGen(10, Type.getType(SSLSocketFactory.class), SSL_SOCKET_FACTORY_FIELD, constantPoolGen);
        classGen.addField(fieldGen.getField());
    }

    private static void createGetDefaultStaticMethod(ClassGen classGen, ConstantPoolGen constantPoolGen, InstructionFactory instructionFactory) {
        InstructionList il = new InstructionList();
        String methodName = "getDefault";
        MethodGen mg = new MethodGen(9, Type.getType(SSLSocketFactory.class), new Type[0], new String[0], methodName, classGen.getClassName(), il, constantPoolGen);
        il.append((Instruction)instructionFactory.createNew(classGen.getClassName()));
        il.append((Instruction)InstructionConst.DUP);
        il.append((Instruction)instructionFactory.createInvoke(classGen.getClassName(), "<init>", (Type)Type.VOID, new Type[0], (short)183));
        il.append((Instruction)InstructionConst.ARETURN);
        mg.setMaxStack();
        classGen.addMethod(mg.getMethod());
        il.dispose();
    }

    private static void closeSafely(ByteArrayOutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setSslSocketFactoryFieldByReflection(Class<? extends AbstractLDAPSSLSocketFactory> clazz, String fieldName, SSLSocketFactory sslSocketFactory) {
        String exceptionMessage = "Unexpected error setting generated static field " + fieldName + "on generated class " + clazz.getName();
        try {
            Field declaredField = clazz.getDeclaredField(fieldName);
            boolean accessible = declaredField.isAccessible();
            try {
                declaredField.setAccessible(true);
                declaredField.set(null, sslSocketFactory);
            }
            finally {
                declaredField.setAccessible(accessible);
            }
        }
        catch (IllegalArgumentException e) {
            throw new ServerScopedRuntimeException(exceptionMessage, e);
        }
        catch (IllegalAccessException e) {
            throw new ServerScopedRuntimeException(exceptionMessage, e);
        }
        catch (NoSuchFieldException e) {
            throw new ServerScopedRuntimeException(exceptionMessage, e);
        }
        catch (SecurityException e) {
            throw new ServerScopedRuntimeException(exceptionMessage, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SSLSocketFactory getStaticFieldByReflection(Class<? extends AbstractLDAPSSLSocketFactory> clazz, String fieldName) {
        String exceptionMessage = "Unexpected error getting generated static field " + fieldName + "on generated class " + clazz.getName();
        Field declaredField = clazz.getDeclaredField(fieldName);
        boolean accessible = declaredField.isAccessible();
        try {
            declaredField.setAccessible(true);
            SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)declaredField.get(null);
            declaredField.setAccessible(accessible);
            return sSLSocketFactory;
        }
        catch (Throwable throwable) {
            try {
                declaredField.setAccessible(accessible);
                throw throwable;
            }
            catch (NoSuchFieldException e) {
                throw new ServerScopedRuntimeException(exceptionMessage, e);
            }
            catch (SecurityException e) {
                throw new ServerScopedRuntimeException(exceptionMessage, e);
            }
            catch (IllegalArgumentException e) {
                throw new ServerScopedRuntimeException(exceptionMessage, e);
            }
            catch (IllegalAccessException e) {
                throw new ServerScopedRuntimeException(exceptionMessage, e);
            }
        }
    }

    private static final class LDAPSSLSocketFactoryAwareDelegatingClassloader
    extends ClassLoader {
        private final String _className;
        private final Class<? extends AbstractLDAPSSLSocketFactory> _clazz;

        private LDAPSSLSocketFactoryAwareDelegatingClassloader(String className, byte[] classBytes, SSLSocketFactory sslSocketFactory) {
            super(LDAPSSLSocketFactoryGenerator.class.getClassLoader());
            this._className = className;
            this._clazz = this.defineClass(className, classBytes, 0, classBytes.length);
            LDAPSSLSocketFactoryGenerator.setSslSocketFactoryFieldByReflection(this._clazz, LDAPSSLSocketFactoryGenerator.SSL_SOCKET_FACTORY_FIELD, sslSocketFactory);
        }

        @Override
        protected Class<?> findClass(String fqcn) throws ClassNotFoundException {
            if (fqcn.equals(this._className)) {
                return this._clazz;
            }
            return this.getParent().loadClass(fqcn);
        }
    }
}

