/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager.oauth2;

import java.net.URI;
import java.util.List;
import org.apache.qpid.server.model.DerivedAttribute;
import org.apache.qpid.server.model.ManagedAttribute;
import org.apache.qpid.server.model.ManagedContextDefault;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.manager.CachingAuthenticationProvider;

@ManagedObject(category=false, type="OAuth2")
public interface OAuth2AuthenticationProvider<T extends OAuth2AuthenticationProvider<T>>
extends CachingAuthenticationProvider<T> {
    public static final String AUTHENTICATION_OAUTH2_CONNECT_TIMEOUT = "qpid.authentication.oauth2.connectTimeout";
    @ManagedContextDefault(name="qpid.authentication.oauth2.connectTimeout")
    public static final int DEFAULT_AUTHENTICATION_OAUTH2_CONNECT_TIMEOUT = 60000;
    public static final String AUTHENTICATION_OAUTH2_READ_TIMEOUT = "qpid.authentication.oauth2.readTimeout";
    @ManagedContextDefault(name="qpid.authentication.oauth2.readTimeout")
    public static final int DEFAULT_AUTHENTICATION_OAUTH2_READ_TIMEOUT = 60000;

    @ManagedAttribute(description="Redirect URI to obtain authorization code grant", mandatory=true, defaultValue="${this:defaultAuthorizationEndpointURI}")
    public URI getAuthorizationEndpointURI();

    public URI getAuthorizationEndpointURI(NamedAddressSpace var1);

    @ManagedAttribute(description="Token endpoint URI to exchange an authorization code grant for an access token", mandatory=true, defaultValue="${this:defaultTokenEndpointURI}")
    public URI getTokenEndpointURI();

    public URI getTokenEndpointURI(NamedAddressSpace var1);

    @ManagedAttribute(description="Whether to use basic authentication when accessing the token endpoint", defaultValue="false")
    public boolean getTokenEndpointNeedsAuth();

    @ManagedAttribute(description="Identity resolver endpoint URI to get user information associated with a given access token", mandatory=true, defaultValue="${this:defaultIdentityResolverEndpointURI}")
    public URI getIdentityResolverEndpointURI();

    public URI getIdentityResolverEndpointURI(NamedAddressSpace var1);

    @ManagedAttribute(description="The type of the IdentityResolver", mandatory=true, validValues={"org.apache.qpid.server.security.auth.manager.oauth2.OAuth2AuthenticationProviderImpl#validIdentityResolvers()"})
    public String getIdentityResolverType();

    @ManagedAttribute(description="Redirect URI used when the user leaves the Web Management Console. If not specified, an internal page is used instead.")
    public URI getPostLogoutURI();

    @ManagedAttribute(description="Client ID to identify qpid to the OAuth endpoints", mandatory=true)
    public String getClientId();

    @ManagedAttribute(description="Client secret to identify qpid to the OAuth endpoints", secure=true)
    public String getClientSecret();

    @ManagedAttribute(description="The OAuth2 access token scope passed to the authorization endpoint", defaultValue="${this:defaultScope}")
    public String getScope();

    @ManagedAttribute(description="TrustStore to use when contacting OAuth2 endpoints")
    public TrustStore getTrustStore();

    @Override
    @ManagedAttribute(defaultValue="[ \"XOAUTH2\" ]")
    public List<String> getSecureOnlyMechanisms();

    public AuthenticationResult authenticateViaAuthorizationCode(String var1, String var2, NamedAddressSpace var3);

    public AuthenticationResult authenticateViaAccessToken(String var1, NamedAddressSpace var2);

    @DerivedAttribute(description="Default redirect URI to obtain authorization code grant")
    public URI getDefaultAuthorizationEndpointURI();

    @DerivedAttribute(description="Default token endpoint URI")
    public URI getDefaultTokenEndpointURI();

    @DerivedAttribute(description="Default identity resolver endpoint URI")
    public URI getDefaultIdentityResolverEndpointURI();

    @DerivedAttribute(description="Default OAuth access token scope passed to the authorization endpoint")
    public String getDefaultScope();

    @DerivedAttribute
    public List<String> getTlsProtocolWhiteList();

    @DerivedAttribute
    public List<String> getTlsProtocolBlackList();

    @DerivedAttribute
    public List<String> getTlsCipherSuiteWhiteList();

    @DerivedAttribute
    public List<String> getTlsCipherSuiteBlackList();

    public int getConnectTimeout();

    public int getReadTimeout();
}

