/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.transport;

import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.qpid.server.transport.AggregateTicker;
import org.apache.qpid.server.transport.NetworkConnectionScheduler;
import org.apache.qpid.server.transport.NonBlockingConnection;
import org.apache.qpid.server.transport.NonBlockingNetworkTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SelectorThread
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectorThread.class);
    private static final long ACCEPT_CANCELLATION_TIMEOUT = Integer.getInteger("qpid.io_network_transport_timeout", 60000).intValue();
    static final String IO_THREAD_NAME_PREFIX = "IO-";
    private final Queue<Runnable> _tasks = new ConcurrentLinkedQueue<Runnable>();
    private final AtomicBoolean _closed = new AtomicBoolean();
    private final NetworkConnectionScheduler _scheduler;
    private final BlockingQueue<Runnable> _workQueue = new LinkedBlockingQueue<Runnable>();
    private final AtomicInteger _nextSelectorTaskIndex = new AtomicInteger();
    private SelectionTask[] _selectionTasks;

    SelectorThread(NetworkConnectionScheduler scheduler, int numberOfSelectors) throws IOException {
        this._scheduler = scheduler;
        this._selectionTasks = new SelectionTask[numberOfSelectors];
        for (int i = 0; i < numberOfSelectors; ++i) {
            this._selectionTasks[i] = new SelectionTask();
        }
        for (SelectionTask task : this._selectionTasks) {
            this._workQueue.add(task);
        }
    }

    public void addAcceptingSocket(final ServerSocketChannel socketChannel, final NonBlockingNetworkTransport nonBlockingNetworkTransport) {
        this._tasks.add(new Runnable(){

            @Override
            public void run() {
                try {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Registering selector on accepting port {} ", (Object)socketChannel.socket().getLocalSocketAddress());
                    }
                    socketChannel.register(SelectorThread.this._selectionTasks[0].getSelector(), 16, nonBlockingNetworkTransport);
                }
                catch (IllegalStateException | ClosedChannelException e) {
                    LOGGER.error("Failed to register selector on accepting port {} ", (Object)socketChannel.socket().getLocalSocketAddress(), (Object)e);
                }
            }
        });
        this._selectionTasks[0].wakeup();
    }

    public void cancelAcceptingSocket(ServerSocketChannel socketChannel) {
        Future<Void> result = this.cancelAcceptingSocketAsync(socketChannel);
        try {
            result.get(ACCEPT_CANCELLATION_TIMEOUT, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Cancellation of accepting socket was interrupted");
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            LOGGER.warn("Cancellation of accepting socket failed", e.getCause());
        }
        catch (TimeoutException e) {
            LOGGER.warn("Cancellation of accepting socket timed out");
        }
    }

    private Future<Void> cancelAcceptingSocketAsync(final ServerSocketChannel socketChannel) {
        final SettableFuture cancellationResult = SettableFuture.create();
        this._tasks.add(new Runnable(){

            @Override
            public void run() {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Cancelling selector on accepting port {} ", (Object)socketChannel.socket().getLocalSocketAddress());
                }
                try {
                    SelectionKey selectionKey = null;
                    try {
                        selectionKey = socketChannel.register(SelectorThread.this._selectionTasks[0].getSelector(), 0);
                    }
                    catch (CancelledKeyException | ClosedChannelException e) {
                        LOGGER.error("Failed to deregister selector on accepting port {}", (Object)socketChannel.socket().getLocalSocketAddress(), (Object)e);
                    }
                    if (selectionKey != null) {
                        selectionKey.cancel();
                    }
                }
                finally {
                    cancellationResult.set(null);
                }
            }
        });
        this._selectionTasks[0].wakeup();
        return cancellationResult;
    }

    @Override
    public void run() {
        String name = Thread.currentThread().getName();
        try {
            do {
                Thread.currentThread().setName(name);
                Runnable task = this._workQueue.take();
                task.run();
            } while (!this._closed.get());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void unregisterConnection(NonBlockingConnection connection) throws ClosedChannelException {
        SelectionKey register = connection.getSocketChannel().register(connection.getSelectionTask().getSelector(), 0);
        register.cancel();
    }

    private void runTasks() {
        while (this._tasks.peek() != null) {
            Runnable task = this._tasks.poll();
            task.run();
        }
    }

    private boolean selectionInterestRequiresUpdate(NonBlockingConnection connection) {
        SelectionTask selectionTask = connection.getSelectionTask();
        if (selectionTask != null) {
            SelectionKey selectionKey = connection.getSocketChannel().keyFor(selectionTask.getSelector());
            int expectedOps = (connection.wantsRead() ? 1 : 0) | (connection.wantsWrite() ? 4 : 0);
            try {
                return selectionKey == null || !selectionKey.isValid() || selectionKey.interestOps() != expectedOps;
            }
            catch (CancelledKeyException e) {
                return true;
            }
        }
        return true;
    }

    public void addConnection(NonBlockingConnection connection) {
        if (this.selectionInterestRequiresUpdate(connection)) {
            SelectionTask selectionTask = this.getNextSelectionTask();
            connection.setSelectionTask(selectionTask);
            selectionTask.getUnregisteredConnections().add(connection);
            selectionTask.wakeup();
        }
    }

    public void returnConnectionToSelector(NonBlockingConnection connection) {
        SelectionTask selectionTask = connection.getSelectionTask();
        if (selectionTask == null) {
            throw new IllegalStateException("returnConnectionToSelector should only be called with connections that are currently assigned a selector task");
        }
        if (this.selectionInterestRequiresUpdate(connection) || connection.getTicker().getModified()) {
            selectionTask.getUnregisteredConnections().add(connection);
            selectionTask.wakeup();
        }
    }

    private SelectionTask getNextSelectionTask() {
        int index;
        while (!this._nextSelectorTaskIndex.compareAndSet(index = this._nextSelectorTaskIndex.get(), (index + 1) % this._selectionTasks.length)) {
        }
        return this._selectionTasks[index];
    }

    void removeConnection(NonBlockingConnection connection) {
        try {
            this.unregisterConnection(connection);
        }
        catch (ClosedChannelException e) {
            LOGGER.debug("Failed to unregister with selector for connection {}. Connection is probably being closed by peer.", (Object)connection);
        }
        catch (CancelledKeyException | ClosedSelectorException e) {
            LOGGER.debug("Failed to unregister with selector for connection {}. Port has probably already been closed.", (Object)connection, (Object)e);
        }
    }

    public void close() {
        Runnable goodNight = new Runnable(){

            @Override
            public void run() {
            }
        };
        this._closed.set(true);
        int count = this._scheduler.getPoolSize();
        while (count-- > 0) {
            this._workQueue.offer(goodNight);
        }
        for (SelectionTask task : this._selectionTasks) {
            task.wakeup();
        }
    }

    public void addToWork(NonBlockingConnection connection) {
        if (this._closed.get()) {
            throw new IllegalStateException("Adding connection work " + connection + " to closed selector thread " + this._scheduler);
        }
        if (connection.setScheduled()) {
            this._workQueue.add(new ConnectionProcessor(this._scheduler, connection));
        }
    }

    private static final class ConnectionProcessor
    implements Runnable {
        private final NetworkConnectionScheduler _scheduler;
        private final NonBlockingConnection _connection;
        private AtomicBoolean _running = new AtomicBoolean();

        public ConnectionProcessor(NetworkConnectionScheduler scheduler, NonBlockingConnection connection) {
            this._scheduler = scheduler;
            this._connection = connection;
        }

        @Override
        public void run() {
            this._scheduler.incrementRunningCount();
            try {
                this.processConnection();
            }
            finally {
                this._scheduler.decrementRunningCount();
            }
        }

        public void processConnection() {
            if (this._running.compareAndSet(false, true)) {
                this._scheduler.processConnection(this._connection);
            }
        }
    }

    public final class SelectionTask
    implements Runnable {
        private final Selector _selector;
        private final AtomicBoolean _selecting = new AtomicBoolean();
        private final AtomicBoolean _inSelect = new AtomicBoolean();
        private final AtomicInteger _wakeups = new AtomicInteger();
        private long _nextTimeout;
        private final Queue<NonBlockingConnection> _unregisteredConnections = new ConcurrentLinkedQueue<NonBlockingConnection>();
        private final Set<NonBlockingConnection> _unscheduledConnections = new HashSet<NonBlockingConnection>();

        private SelectionTask() throws IOException {
            this._selector = Selector.open();
        }

        @Override
        public void run() {
            this.performSelect();
        }

        public boolean acquireSelecting() {
            return this._selecting.compareAndSet(false, true);
        }

        public void clearSelecting() {
            this._selecting.set(false);
        }

        public Selector getSelector() {
            return this._selector;
        }

        public Queue<NonBlockingConnection> getUnregisteredConnections() {
            return this._unregisteredConnections;
        }

        public Set<NonBlockingConnection> getUnscheduledConnections() {
            return this._unscheduledConnections;
        }

        private List<NonBlockingConnection> processUnscheduledConnections() {
            this._nextTimeout = Integer.MAX_VALUE;
            if (this.getUnscheduledConnections().isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList toBeScheduled = new ArrayList();
            long currentTime = System.currentTimeMillis();
            Iterator<NonBlockingConnection> iterator = this.getUnscheduledConnections().iterator();
            while (iterator.hasNext()) {
                NonBlockingConnection connection = iterator.next();
                AggregateTicker ticker = connection.getTicker();
                int period = ticker.getTimeToNextTick(currentTime);
                ticker.resetModified();
                if (period <= 0 || connection.isStateChanged()) {
                    toBeScheduled.add(connection);
                    try {
                        connection.getSocketChannel().register(this._selector, 0, connection);
                    }
                    catch (CancelledKeyException | ClosedChannelException e) {
                        LOGGER.debug("Failed to register with selector for connection " + connection + ". Connection is probably being closed by peer.", (Throwable)e);
                    }
                    iterator.remove();
                    continue;
                }
                this._nextTimeout = Math.min((long)period, this._nextTimeout);
            }
            return toBeScheduled.isEmpty() ? Collections.emptyList() : toBeScheduled;
        }

        private List<NonBlockingConnection> processSelectionKeys() {
            Set<SelectionKey> selectionKeys = this._selector.selectedKeys();
            if (selectionKeys.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<NonBlockingConnection> toBeScheduled = new ArrayList<NonBlockingConnection>();
            for (SelectionKey key : selectionKeys) {
                if (key.attachment() instanceof NonBlockingNetworkTransport) {
                    NonBlockingNetworkTransport transport = (NonBlockingNetworkTransport)key.attachment();
                    ServerSocketChannel channel = (ServerSocketChannel)key.channel();
                    SocketAddress localSocketAddress = channel.socket().getLocalSocketAddress();
                    try {
                        channel.register(this._selector, 0, transport);
                    }
                    catch (ClosedChannelException e) {
                        LOGGER.error("Failed to register selector on accepting port {} ", (Object)localSocketAddress, (Object)e);
                    }
                    catch (CancelledKeyException e) {
                        LOGGER.info("Failed to register selector on accepting port {} because selector key is already cancelled", (Object)localSocketAddress, (Object)e);
                    }
                    SelectorThread.this._workQueue.add(() -> {
                        try {
                            SelectorThread.this._scheduler.incrementRunningCount();
                            transport.acceptSocketChannel(channel);
                            return;
                        }
                        finally {
                            try {
                                channel.register(this._selector, 16, transport);
                                this.wakeup();
                            }
                            catch (ClosedSelectorException e) {
                                LOGGER.info("Failed to register selector on accepting port {} because selector is already closed. This is probably a harmless race-condition (QPID-7399)", (Object)localSocketAddress);
                            }
                            catch (ClosedChannelException e) {
                                LOGGER.error("Failed to register selector on accepting port {}", (Object)localSocketAddress, (Object)e);
                            }
                            catch (CancelledKeyException e) {
                                LOGGER.info("Failed to register selector on accepting port {} because selector key is already cancelled", (Object)localSocketAddress, (Object)e);
                            }
                            finally {
                                SelectorThread.this._scheduler.decrementRunningCount();
                            }
                        }
                    });
                    continue;
                }
                NonBlockingConnection connection = (NonBlockingConnection)key.attachment();
                if (connection == null) continue;
                try {
                    key.channel().register(this._selector, 0, connection);
                }
                catch (CancelledKeyException | ClosedChannelException exception) {
                    // empty catch block
                }
                toBeScheduled.add(connection);
                this.getUnscheduledConnections().remove(connection);
            }
            selectionKeys.clear();
            return toBeScheduled;
        }

        private List<NonBlockingConnection> reregisterUnregisteredConnections() {
            NonBlockingConnection unregisteredConnection;
            if (this.getUnregisteredConnections().isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList unregisterableConnections = new ArrayList();
            while ((unregisteredConnection = this.getUnregisteredConnections().poll()) != null) {
                this.getUnscheduledConnections().add(unregisteredConnection);
                int ops = (unregisteredConnection.wantsRead() ? 1 : 0) | (unregisteredConnection.wantsWrite() ? 4 : 0);
                try {
                    unregisteredConnection.getSocketChannel().register(this._selector, ops, unregisteredConnection);
                }
                catch (CancelledKeyException | ClosedChannelException e) {
                    unregisterableConnections.add(unregisteredConnection);
                }
            }
            return unregisterableConnections.isEmpty() ? Collections.emptyList() : unregisterableConnections;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void performSelect() {
            SelectorThread.this._scheduler.incrementRunningCount();
            try {
                while (!SelectorThread.this._closed.get() && this.acquireSelecting()) {
                    ArrayList<ConnectionProcessor> connections;
                    block20: {
                        connections = new ArrayList<ConnectionProcessor>();
                        if (SelectorThread.this._closed.get()) break block20;
                        Thread.currentThread().setName(SelectorThread.this._scheduler.getSelectorThreadName());
                        this._inSelect.set(true);
                        try {
                            if (this._wakeups.getAndSet(0) > 0) {
                                this._selector.selectNow();
                            } else {
                                this._selector.select(this._nextTimeout);
                            }
                        }
                        catch (IOException e) {
                            LOGGER.error("Failed to trying to select()", (Throwable)e);
                            this.closeSelector();
                            this.clearSelecting();
                            SelectorThread.this._scheduler.decrementRunningCount();
                            return;
                        }
                        finally {
                            this._inSelect.set(false);
                        }
                        for (NonBlockingConnection connection : this.processSelectionKeys()) {
                            if (!connection.setScheduled()) continue;
                            connections.add(new ConnectionProcessor(SelectorThread.this._scheduler, connection));
                        }
                        for (NonBlockingConnection connection : this.reregisterUnregisteredConnections()) {
                            if (!connection.setScheduled()) continue;
                            connections.add(new ConnectionProcessor(SelectorThread.this._scheduler, connection));
                        }
                        for (NonBlockingConnection connection : this.processUnscheduledConnections()) {
                            if (!connection.setScheduled()) continue;
                            connections.add(new ConnectionProcessor(SelectorThread.this._scheduler, connection));
                        }
                        SelectorThread.this.runTasks();
                        break block20;
                        finally {
                            this.clearSelecting();
                        }
                    }
                    if (connections.isEmpty()) continue;
                    SelectorThread.this._workQueue.addAll(connections);
                    SelectorThread.this._workQueue.add(this);
                    for (ConnectionProcessor connectionProcessor : connections) {
                        connectionProcessor.processConnection();
                    }
                }
                if (!SelectorThread.this._closed.get()) return;
                if (!this.acquireSelecting()) return;
                this.closeSelector();
                return;
            }
            finally {
                SelectorThread.this._scheduler.decrementRunningCount();
            }
        }

        private void closeSelector() {
            try {
                if (this._selector.isOpen()) {
                    this._selector.close();
                }
            }
            catch (IOException e) {
                LOGGER.debug("Failed to close selector", (Throwable)e);
            }
        }

        public void wakeup() {
            this._wakeups.compareAndSet(0, 1);
            if (this._inSelect.get() && this._wakeups.get() != 0) {
                this._selector.wakeup();
            }
        }
    }
}

