/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.transport;

import com.google.common.base.Supplier;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.qpid.server.transport.SchedulingDelayNotificationListener;
import org.apache.qpid.server.transport.network.Ticker;
import org.apache.qpid.server.util.Action;

public class TransactionTimeoutTicker
implements Ticker,
SchedulingDelayNotificationListener {
    private final long _timeoutValue;
    private final Action<Long> _notification;
    private final Supplier<Long> _timeSupplier;
    private final long _notificationRepeatPeriod;
    private AtomicLong _accumulatedSchedulingDelay = new AtomicLong();
    private volatile long _nextNotificationTime = 0L;
    private volatile long _lastTransactionTimeStamp = 0L;

    public TransactionTimeoutTicker(long timeoutValue, long notificationRepeatPeriod, Supplier<Long> timeStampSupplier, Action<Long> notification) {
        this._timeoutValue = timeoutValue;
        this._notification = notification;
        this._lastTransactionTimeStamp = (Long)timeStampSupplier.get();
        this._timeSupplier = timeStampSupplier;
        this._notificationRepeatPeriod = notificationRepeatPeriod;
    }

    @Override
    public int getTimeToNextTick(long currentTime) {
        long transactionTimeStamp = (Long)this._timeSupplier.get();
        int tick = this.calculateTimeToNextTick(currentTime, transactionTimeStamp);
        if (tick <= 0 && this._nextNotificationTime > currentTime) {
            tick = (int)(this._nextNotificationTime - currentTime);
        }
        return tick;
    }

    @Override
    public int tick(long currentTime) {
        long transactionTimeStamp = (Long)this._timeSupplier.get();
        int tick = this.calculateTimeToNextTick(currentTime, transactionTimeStamp);
        if (tick <= 0) {
            if (currentTime >= this._nextNotificationTime) {
                long idleTime = currentTime - transactionTimeStamp;
                this._nextNotificationTime = currentTime + this._notificationRepeatPeriod;
                this._notification.performAction(idleTime);
            } else {
                tick = (int)(this._nextNotificationTime - currentTime);
            }
        }
        return tick;
    }

    private int calculateTimeToNextTick(long currentTime, long transactionTimeStamp) {
        if (transactionTimeStamp != this._lastTransactionTimeStamp) {
            this._lastTransactionTimeStamp = transactionTimeStamp;
            this._nextNotificationTime = 0L;
            this._accumulatedSchedulingDelay.set(0L);
        }
        if (transactionTimeStamp > 0L) {
            return (int)(transactionTimeStamp + this._timeoutValue + this._accumulatedSchedulingDelay.get() - currentTime);
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public void notifySchedulingDelay(long schedulingDelay) {
        if (schedulingDelay > 0L) {
            long accumulatedSchedulingDelay;
            while (!this._accumulatedSchedulingDelay.compareAndSet(accumulatedSchedulingDelay = this._accumulatedSchedulingDelay.get(), accumulatedSchedulingDelay + schedulingDelay)) {
            }
        }
    }
}

