/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhost.connection;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import org.apache.qpid.server.security.auth.AuthenticatedPrincipal;
import org.apache.qpid.server.transport.AMQPConnection;
import org.apache.qpid.server.virtualhost.ConnectionPrincipalStatistics;
import org.apache.qpid.server.virtualhost.ConnectionPrincipalStatisticsRegistry;
import org.apache.qpid.server.virtualhost.ConnectionStatisticsRegistrySettings;
import org.apache.qpid.server.virtualhost.connection.ConnectionPrincipalStatisticsImpl;

public class ConnectionPrincipalStatisticsRegistryImpl
implements ConnectionPrincipalStatisticsRegistry {
    private final Map<Principal, ConnectionPrincipalStatisticsImpl> _principalStatistics = new ConcurrentHashMap<Principal, ConnectionPrincipalStatisticsImpl>();
    private final ConnectionStatisticsRegistrySettings _settings;

    public ConnectionPrincipalStatisticsRegistryImpl(ConnectionStatisticsRegistrySettings settings) {
        this._settings = settings;
    }

    @Override
    public ConnectionPrincipalStatistics connectionOpened(AMQPConnection<?> connection) {
        Subject subject = connection.getSubject();
        AuthenticatedPrincipal principal = AuthenticatedPrincipal.getAuthenticatedPrincipalFromSubject(subject);
        return this._principalStatistics.compute(principal, (p, s) -> this.connectionOpened((ConnectionPrincipalStatisticsImpl)s, connection.getCreatedTime()));
    }

    @Override
    public ConnectionPrincipalStatistics connectionClosed(AMQPConnection<?> connection) {
        Subject subject = connection.getSubject();
        AuthenticatedPrincipal principal = AuthenticatedPrincipal.getAuthenticatedPrincipalFromSubject(subject);
        return this._principalStatistics.computeIfPresent(principal, (p, s) -> this.connectionClosed((ConnectionPrincipalStatisticsImpl)s));
    }

    @Override
    public void reevaluateConnectionStatistics() {
        new HashSet<Principal>(this._principalStatistics.keySet()).forEach(this::reevaluateConnectionStatistics);
    }

    @Override
    public void reset() {
        this._principalStatistics.clear();
    }

    int getConnectionCount(Principal principal) {
        ConnectionPrincipalStatistics cs = this._principalStatistics.get(principal);
        if (cs != null) {
            return cs.getConnectionCount();
        }
        return 0;
    }

    int getConnectionFrequency(Principal principal) {
        ConnectionPrincipalStatistics cs = this._principalStatistics.get(principal);
        if (cs != null) {
            return cs.getConnectionFrequency();
        }
        return 0;
    }

    private ConnectionPrincipalStatisticsImpl connectionOpened(ConnectionPrincipalStatisticsImpl current, Date createdTime) {
        List<Long> connectionCreatedTimes;
        if (current == null) {
            return new ConnectionPrincipalStatisticsImpl(1, Collections.singletonList(createdTime.getTime()));
        }
        long frequencyPeriod = this.getConnectionFrequencyPeriodMillis();
        if (frequencyPeriod > 0L) {
            connectionCreatedTimes = this.findTimesWithinPeriod(current.getLatestConnectionCreatedTimes(), frequencyPeriod);
            connectionCreatedTimes.add(createdTime.getTime());
        } else {
            connectionCreatedTimes = Collections.emptyList();
        }
        return new ConnectionPrincipalStatisticsImpl(current.getConnectionCount() + 1, connectionCreatedTimes);
    }

    private ConnectionPrincipalStatisticsImpl connectionClosed(ConnectionPrincipalStatisticsImpl current) {
        return this.createStatisticsOrNull(Math.max(0, current.getConnectionCount() - 1), current.getLatestConnectionCreatedTimes());
    }

    private void reevaluateConnectionStatistics(Principal authenticatedPrincipal) {
        this._principalStatistics.computeIfPresent(authenticatedPrincipal, (principal, current) -> this.reevaluate((ConnectionPrincipalStatisticsImpl)current));
    }

    private ConnectionPrincipalStatisticsImpl reevaluate(ConnectionPrincipalStatisticsImpl current) {
        return this.createStatisticsOrNull(current.getConnectionCount(), current.getLatestConnectionCreatedTimes());
    }

    private ConnectionPrincipalStatisticsImpl createStatisticsOrNull(int openConnectionCount, List<Long> currentConnectionCreatedTimes) {
        List<Long> connectionCreatedTimes = this.findTimesWithinPeriod(currentConnectionCreatedTimes, this.getConnectionFrequencyPeriodMillis());
        if (openConnectionCount == 0 && connectionCreatedTimes.isEmpty()) {
            return null;
        }
        return new ConnectionPrincipalStatisticsImpl(openConnectionCount, connectionCreatedTimes);
    }

    private List<Long> findTimesWithinPeriod(Collection<Long> currentConnectionCreatedTimes, long frequencyPeriod) {
        List<Long> connectionCreatedTimes;
        if (frequencyPeriod > 0L) {
            long periodEnd = System.currentTimeMillis();
            long periodStart = periodEnd - frequencyPeriod;
            connectionCreatedTimes = this.findTimesBetween(currentConnectionCreatedTimes, periodStart, periodEnd);
        } else {
            connectionCreatedTimes = Collections.emptyList();
        }
        return connectionCreatedTimes;
    }

    private List<Long> findTimesBetween(Collection<Long> connectionCreatedTimes, long periodStart, long periodEnd) {
        return connectionCreatedTimes.stream().mapToLong(Long::longValue).filter(t -> t >= periodStart && t <= periodEnd).boxed().collect(Collectors.toCollection(ArrayList::new));
    }

    private long getConnectionFrequencyPeriodMillis() {
        return this._settings.getConnectionFrequencyPeriod().toMillis();
    }
}

