/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.filter;

import java.util.List;
import org.apache.qpid.server.filter.AMQPFilterTypes;
import org.apache.qpid.server.filter.JMSSelectorFilter;
import org.apache.qpid.server.filter.MessageFilter;
import org.apache.qpid.server.filter.SelectorParsingException;
import org.apache.qpid.server.filter.selector.ParseException;
import org.apache.qpid.server.filter.selector.TokenMgrError;
import org.apache.qpid.server.plugin.MessageFilterFactory;
import org.apache.qpid.server.plugin.PluggableService;

@PluggableService
public final class JMSSelectorFilterFactory
implements MessageFilterFactory {
    @Override
    public String getType() {
        return AMQPFilterTypes.JMS_SELECTOR.toString();
    }

    @Override
    public MessageFilter newInstance(List<String> arguments) {
        if (arguments == null || arguments.size() != 1) {
            throw new IllegalArgumentException("Cannot create a filter from these arguments: " + arguments);
        }
        String arg = arguments.get(0);
        try {
            return new JMSSelectorFilter(arg);
        }
        catch (SelectorParsingException | ParseException | TokenMgrError e) {
            throw new IllegalArgumentException("Cannot create an JMS Selector from '" + arg + "'", e);
        }
    }
}

