/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectAttribute;
import org.apache.qpid.server.model.ConfiguredSettableAttribute;
import org.apache.qpid.server.store.ConfiguredObjectDependency;
import org.apache.qpid.server.store.ConfiguredObjectIdDependency;
import org.apache.qpid.server.store.ConfiguredObjectNameDependency;
import org.apache.qpid.server.store.ConfiguredObjectRecord;
import org.apache.qpid.server.store.UnresolvedConfiguredObject;

public abstract class AbstractUnresolvedObject<C extends ConfiguredObject<C>>
implements UnresolvedConfiguredObject<C> {
    private final Class<C> _clazz;
    private final Collection<ConfiguredObjectDependency<?>> _unresolvedObjects = new ArrayList();
    private final ConfiguredObjectRecord _record;
    private final ConfiguredObject<?> _parent;

    protected AbstractUnresolvedObject(Class<C> clazz, ConfiguredObjectRecord record, ConfiguredObject<?> parent) {
        this._clazz = clazz;
        this._record = record;
        this._parent = parent;
        Collection<ConfiguredObjectAttribute<C, ?>> attributes = parent.getModel().getTypeRegistry().getAttributes(clazz);
        for (ConfiguredObjectAttribute<C, ?> attribute : attributes) {
            Object attrValue;
            Type returnType;
            Class<ConfiguredObject> attrClass;
            if (!attribute.isPersisted()) continue;
            Class attributeType = attribute.getType();
            if (ConfiguredObject.class.isAssignableFrom(attributeType)) {
                this.addUnresolvedObject(attributeType, attribute.getName(), attribute.isAutomated() && ((ConfiguredSettableAttribute)attribute).isMandatory());
                continue;
            }
            if (!Collection.class.isAssignableFrom(attributeType) || (attrClass = this.getMemberType(returnType = attribute.getGenericType())) == null || (attrValue = this._record.getAttributes().get(attribute.getName())) == null) continue;
            if (attrValue instanceof Collection) {
                for (Object val : (Collection)attrValue) {
                    this.addUnresolvedObject(attrClass, attribute.getName(), val);
                }
                continue;
            }
            if (attrValue instanceof Object[]) {
                for (Object val : (Object[])attrValue) {
                    this.addUnresolvedObject(attrClass, attribute.getName(), val);
                }
                continue;
            }
            this.addUnresolvedObject(attrClass, attribute.getName(), attrValue);
        }
    }

    private Class<? extends ConfiguredObject> getMemberType(Type returnType) {
        Class<ConfiguredObject> categoryClass = null;
        if (returnType instanceof ParameterizedType) {
            Type type = ((ParameterizedType)returnType).getActualTypeArguments()[0];
            if (type instanceof Class && ConfiguredObject.class.isAssignableFrom((Class)type)) {
                categoryClass = (Class<ConfiguredObject>)type;
            } else if (type instanceof ParameterizedType) {
                Type rawType = ((ParameterizedType)type).getRawType();
                if (rawType instanceof Class && ConfiguredObject.class.isAssignableFrom((Class)rawType)) {
                    categoryClass = (Class)rawType;
                }
            } else if (type instanceof TypeVariable) {
                Type boundType;
                Type[] bounds;
                Type[] typeArray = bounds = ((TypeVariable)type).getBounds();
                int n = typeArray.length;
                for (int i = 0; i < n && (categoryClass = this.getMemberType(boundType = typeArray[i])) == null; ++i) {
                }
            }
        }
        return categoryClass;
    }

    public ConfiguredObjectRecord getRecord() {
        return this._record;
    }

    @Override
    public ConfiguredObject<?> getParent() {
        return this._parent;
    }

    private void addUnresolvedObject(Class<? extends ConfiguredObject> clazz, String attributeName, boolean mandatory) {
        Object attrValue = this._record.getAttributes().get(attributeName);
        if (attrValue != null) {
            this.addUnresolvedObject(clazz, attributeName, attrValue);
        } else if (mandatory) {
            throw new IllegalConfigurationException("Missing attribute " + attributeName + " has no value");
        }
    }

    private void addUnresolvedObject(Class<? extends ConfiguredObject> clazz, String attributeName, Object attrValue) {
        if (attrValue instanceof UUID) {
            this._unresolvedObjects.add(new IdDependency<ConfiguredObject>(clazz, attributeName, (UUID)attrValue));
        } else if (attrValue instanceof String) {
            String interpolatedValue = AbstractConfiguredObject.interpolate(this._parent, (String)attrValue);
            try {
                this._unresolvedObjects.add(new IdDependency<ConfiguredObject>(clazz, attributeName, UUID.fromString(interpolatedValue)));
            }
            catch (IllegalArgumentException e) {
                this._unresolvedObjects.add(new NameDependency<ConfiguredObject>(clazz, attributeName, interpolatedValue));
            }
        } else if (!clazz.isInstance(attrValue)) {
            throw new IllegalArgumentException("Cannot convert from type " + attrValue.getClass() + " to a configured object dependency");
        }
    }

    protected abstract <X extends ConfiguredObject<X>> void resolved(ConfiguredObjectDependency<X> var1, X var2);

    @Override
    public Collection<ConfiguredObjectDependency<?>> getUnresolvedDependencies() {
        return this._unresolvedObjects;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{class=" + this._clazz.getSimpleName() + ", unresolvedObjects=" + this._unresolvedObjects + '}';
    }

    private class NameDependency<X extends ConfiguredObject<X>>
    extends Dependency<X>
    implements ConfiguredObjectNameDependency<X> {
        private final String _name;

        public NameDependency(Class<X> clazz, String attributeName, String attrValue) {
            super(clazz, attributeName);
            this._name = attrValue;
        }

        @Override
        public String getName() {
            return this._name;
        }

        public String toString() {
            return "NameDependency{" + this.getCategoryClass().getSimpleName() + ", \"" + this._name + "\" }";
        }
    }

    private class IdDependency<X extends ConfiguredObject<X>>
    extends Dependency<X>
    implements ConfiguredObjectIdDependency<X> {
        private final UUID _id;

        public IdDependency(Class<X> clazz, String attributeName, UUID id) {
            super(clazz, attributeName);
            this._id = id;
        }

        @Override
        public UUID getId() {
            return this._id;
        }

        public String toString() {
            return "IdDependency{" + this.getCategoryClass().getSimpleName() + ", " + this._id + " }";
        }
    }

    private abstract class Dependency<X extends ConfiguredObject<X>>
    implements ConfiguredObjectDependency<X> {
        private final Class<X> _clazz;
        private final String _attributeName;

        public Dependency(Class<X> clazz, String attributeName) {
            this._clazz = clazz;
            this._attributeName = attributeName;
        }

        @Override
        public final Class<X> getCategoryClass() {
            return this._clazz;
        }

        @Override
        public final void resolve(X object) {
            AbstractUnresolvedObject.this._unresolvedObjects.remove(this);
            AbstractUnresolvedObject.this.resolved(this, object);
        }

        public final String getAttributeName() {
            return this._attributeName;
        }
    }
}

