/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.sasl.external;

import java.security.Principal;
import javax.security.auth.x500.X500Principal;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.UsernamePrincipal;
import org.apache.qpid.server.security.auth.manager.ExternalAuthenticationManager;
import org.apache.qpid.server.security.auth.sasl.SaslNegotiator;
import org.apache.qpid.server.transport.network.security.ssl.SSLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalNegotiator
implements SaslNegotiator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalNegotiator.class);
    private final AuthenticationResult _result;
    private final Principal _principal;
    private volatile boolean _isComplete;

    public ExternalNegotiator(ExternalAuthenticationManager externalAuthenticationManager, Principal externalPrincipal) {
        boolean useFullDN = externalAuthenticationManager.getUseFullDN();
        if (externalPrincipal instanceof X500Principal && !useFullDN) {
            String dn = ((X500Principal)externalPrincipal).getName("RFC2253");
            LOGGER.debug("Parsing username from Principal DN: {}", (Object)dn);
            String username = SSLUtil.getIdFromSubjectDN(dn);
            if (username.isEmpty()) {
                LOGGER.debug("CN value was empty in Principal name, unable to construct username");
                this._principal = null;
            } else {
                LOGGER.debug("Constructing Principal with username: {}", (Object)username);
                this._principal = new UsernamePrincipal(username, externalAuthenticationManager);
            }
        } else {
            LOGGER.debug("Using external Principal: {}", (Object)externalPrincipal);
            this._principal = externalPrincipal;
        }
        this._result = this._principal == null ? new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, new IllegalArgumentException("CN value was empty in Principal name, unable to construct username")) : new AuthenticationResult(this._principal);
    }

    @Override
    public AuthenticationResult handleResponse(byte[] response) {
        if (this._isComplete) {
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, new IllegalStateException("Multiple Authentications not permitted."));
        }
        this._isComplete = true;
        return this._result;
    }

    @Override
    public void dispose() {
    }

    @Override
    public String getAttemptedAuthenticationId() {
        return this._principal == null ? null : this._principal.getName();
    }
}

