/*
 * Decompiled with CFR 0.152.
 */
package netapp.manage;

public class Base16 {
    static final String hexChars = "0123456789abcdef";

    static int hexValue(char c) {
        if ((c = (char)(c & 0xFF)) >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return 10 + (c - 97);
        }
        if (c >= 'A' && c <= 'F') {
            return 10 + (c - 65);
        }
        throw new NumberFormatException("The base-16 input character " + c + " is not a hexidecimal character");
    }

    static char hexChar(int n) {
        return hexChars.charAt(n &= 0xF);
    }

    public static String encode(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            stringBuffer.append(Base16.hexChar(c >> 4));
            stringBuffer.append(Base16.hexChar(c));
        }
        return stringBuffer.toString();
    }

    public static char[] decode(String string) {
        if (string == null) {
            return null;
        }
        if (0 != string.length() % 2) {
            throw new IllegalArgumentException("The base-16 input text must contain an even number of characters; " + string + " has " + string.length() + " characters.");
        }
        int n = string.length() / 2;
        char[] cArray = new char[n];
        if (0 == n) {
            return cArray;
        }
        for (int i = 0; i < n; ++i) {
            int n2 = Base16.hexValue(string.charAt(2 * i));
            int n3 = Base16.hexValue(string.charAt(2 * i + 1));
            cArray[i] = (char)(n2 << 4 | n3);
        }
        return cArray;
    }
}

