/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.dsml.jndi;

import java.util.Enumeration;
import java.util.Vector;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchResult;
import org.exolab.castor.dsml.Consumer;
import org.exolab.castor.dsml.ImportDescriptor;
import org.exolab.castor.dsml.ImportExportException;
import org.exolab.castor.dsml.Importer;
import org.exolab.castor.dsml.jndi.JNDIConsumer;

public class JNDIImporter
extends Importer {
    private DirContext _ctx;

    public JNDIImporter(DirContext dirContext) {
        this._ctx = dirContext;
    }

    protected Consumer createConsumer() {
        return new JNDIConsumer();
    }

    public void importEntry(SearchResult searchResult, int n) throws NamingException {
        if (searchResult.getAttributes().size() == 0) {
            if ((n & 1) != 0) {
                try {
                    this._ctx.lookup(searchResult.getName());
                    this._ctx.unbind(searchResult.getName());
                    this.notify(searchResult.getName(), 3);
                }
                catch (NameNotFoundException nameNotFoundException) {
                    this.notify(searchResult.getName(), 0);
                }
            } else {
                this.notify(searchResult.getName(), 0);
            }
        } else {
            try {
                Attribute attribute;
                Attributes attributes = this._ctx.getAttributes(searchResult.getName());
                Vector<ModificationItem> vector = new Vector<ModificationItem>();
                Attributes attributes2 = searchResult.getAttributes();
                NamingEnumeration<? extends Attribute> namingEnumeration = attributes2.getAll();
                while (namingEnumeration.hasMore()) {
                    attribute = namingEnumeration.next();
                    if (attributes.get(attribute.getID()) != null) {
                        if ((n & 8) != 0) continue;
                        if (attribute.size() > 0) {
                            vector.addElement(new ModificationItem(2, attribute));
                            continue;
                        }
                        vector.addElement(new ModificationItem(3, attribute));
                        continue;
                    }
                    if ((n & 0x10) != 0 || attribute.size() <= 0) continue;
                    vector.addElement(new ModificationItem(1, attribute));
                }
                if ((n & 2) != 0) {
                    namingEnumeration = attributes.getAll();
                    while (namingEnumeration.hasMore()) {
                        attribute = namingEnumeration.next();
                        if (attributes2.get(attribute.getID()) != null) continue;
                        vector.addElement(new ModificationItem(3, attribute));
                    }
                }
                if (vector.size() > 0) {
                    Object[] objectArray = new ModificationItem[vector.size()];
                    vector.copyInto(objectArray);
                    this._ctx.modifyAttributes(searchResult.getName(), (ModificationItem[])objectArray);
                    this.notify(searchResult.getName(), 2);
                } else {
                    this.notify(searchResult.getName(), 0);
                }
            }
            catch (NameNotFoundException nameNotFoundException) {
                if ((n & 4) == 0) {
                    this._ctx.bind(searchResult.getName(), null, searchResult.getAttributes());
                    this.notify(searchResult.getName(), 1);
                }
                this.notify(searchResult.getName(), 0);
            }
        }
    }

    public void importEntries(NamingEnumeration namingEnumeration) throws NamingException {
        if (this.getImportDescriptor() == null) {
            this.setImportDescriptor(new ImportDescriptor());
        }
        while (namingEnumeration.hasMore()) {
            SearchResult searchResult = (SearchResult)namingEnumeration.next();
            this.importEntry(searchResult, this.getImportDescriptor().getPolicy(searchResult.getName()));
        }
    }

    public void importEntries(Enumeration enumeration) throws ImportExportException {
        if (this.getImportDescriptor() == null) {
            this.setImportDescriptor(new ImportDescriptor());
        }
        try {
            while (enumeration.hasMoreElements()) {
                SearchResult searchResult = (SearchResult)enumeration.nextElement();
                this.importEntry(searchResult, this.getImportDescriptor().getPolicy(searchResult.getName()));
            }
        }
        catch (NamingException namingException) {
            throw new ImportExportException(namingException);
        }
    }
}

