/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo;

import java.io.PrintWriter;
import java.io.Serializable;
import java.rmi.Remote;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.exolab.castor.jdo.DataObjects;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.DatabaseNotFoundException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.engine.DatabaseImpl;
import org.exolab.castor.jdo.engine.DatabaseRegistry;
import org.exolab.castor.jdo.engine.TxDatabaseMap;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.OutputLogInterceptor;
import org.exolab.castor.persist.spi.CallbackInterceptor;
import org.exolab.castor.persist.spi.InstanceFactory;
import org.exolab.castor.persist.spi.LogInterceptor;
import org.exolab.castor.util.Messages;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class JDO
implements DataObjects,
Referenceable,
ObjectFactory,
Serializable {
    public static final int DefaultLockTimeout = 10;
    private String _dbConf;
    private LogInterceptor _logInterceptor;
    private CallbackInterceptor _callback;
    private InstanceFactory _instanceFactory;
    private int _lockTimeout = 10;
    private String _dbName;
    private String _description = "Castor JDO";
    private String _tmName = "java:comp/TransactionManager";
    private TransactionManager tm = null;
    private ClassLoader _classLoader;
    private EntityResolver _entityResolver;
    private TxDatabaseMap _txDbPool;
    private boolean _autoStore = false;

    public JDO() {
    }

    public JDO(String string) {
        this._dbName = string;
    }

    public void setLogWriter(PrintWriter printWriter) {
        this._logInterceptor = printWriter == null ? null : new OutputLogInterceptor(printWriter);
    }

    public void setLogInterceptor(LogInterceptor logInterceptor) {
        this._logInterceptor = logInterceptor;
    }

    public void setCallbackInterceptor(CallbackInterceptor callbackInterceptor) {
        this._callback = callbackInterceptor;
    }

    public void setInstanceFactory(InstanceFactory instanceFactory) {
        this._instanceFactory = instanceFactory;
    }

    public LogInterceptor getLogInterceptor() {
        return this._logInterceptor;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this._classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this._entityResolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this._entityResolver;
    }

    public void setDescription(String string) {
        if (string == null) {
            throw new NullPointerException("DataSource: Argument 'description' is null");
        }
        this._description = string;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDatabaseName(String string) {
        this._dbName = string;
    }

    public String getDatabaseName() {
        return this._dbName;
    }

    public void setLockTimeout(int n) {
        this._lockTimeout = n;
    }

    public int getLockTimeout() {
        return this._lockTimeout;
    }

    public void setConfiguration(String string) {
        this._dbConf = string;
    }

    public String getConfiguration() {
        return this._dbConf;
    }

    public void setTransactionManager(String string) {
        this._tmName = string;
    }

    public String getTransactionManager() {
        return this._tmName;
    }

    public void setDatabasePooling(boolean bl) {
        if (!bl) {
            if (this._txDbPool == null) {
                return;
            }
            if (this._txDbPool.isEmpty()) {
                this._txDbPool = null;
                return;
            }
            throw new IllegalStateException("JDO Pooling started. It can not be set to false");
        }
        if (this._txDbPool == null) {
            this._txDbPool = new TxDatabaseMap();
        }
    }

    public boolean getDatabasePooling() {
        return this._txDbPool != null;
    }

    public void setAutoStore(boolean bl) {
        this._autoStore = bl;
    }

    public boolean isAutoStore() {
        return this._autoStore;
    }

    public Database getDatabase() throws DatabaseNotFoundException, PersistenceException {
        block14: {
            if (this._dbName == null) {
                throw new IllegalStateException("Called 'getDatabase' without first setting database name");
            }
            if (DatabaseRegistry.getDatabaseRegistry(this._dbName) == null) {
                if (this._dbConf == null) {
                    throw new DatabaseNotFoundException(Messages.format("jdo.dbNoMapping", this._dbName));
                }
                try {
                    DatabaseRegistry.loadDatabase(new InputSource(this._dbConf), this._entityResolver, this._logInterceptor, this._classLoader);
                }
                catch (MappingException mappingException) {
                    throw new DatabaseNotFoundException(mappingException);
                }
            }
            if (this._tmName != null) {
                try {
                    if (this.tm == null) {
                        InitialContext initialContext = new InitialContext();
                        this.tm = (TransactionManager)initialContext.lookup(this._tmName);
                    }
                    Transaction transaction = this.tm.getTransaction();
                    if (this._txDbPool != null && this._txDbPool.containsTx(transaction)) {
                        return this._txDbPool.get(transaction);
                    }
                    if (transaction.getStatus() == 0) {
                        DatabaseImpl databaseImpl = new DatabaseImpl(this._dbName, this._lockTimeout, this._logInterceptor, this._callback, this._instanceFactory, transaction, this._classLoader, this._autoStore);
                        if (this._txDbPool != null) {
                            this._txDbPool.put(transaction, databaseImpl);
                        }
                        transaction.registerSynchronization((Synchronization)databaseImpl);
                        return databaseImpl;
                    }
                }
                catch (NoInitialContextException noInitialContextException) {
                }
                catch (NameNotFoundException nameNotFoundException) {
                }
                catch (Exception exception) {
                    if (this._logInterceptor == null) break block14;
                    this._logInterceptor.exception(exception);
                }
            }
        }
        return new DatabaseImpl(this._dbName, this._lockTimeout, this._logInterceptor, this._callback, this._instanceFactory, null, this._classLoader, this._autoStore);
    }

    public static void loadConfiguration(String string) throws MappingException {
        DatabaseRegistry.loadDatabase(new InputSource(string), null, null, null);
    }

    public static void loadConfiguration(String string, ClassLoader classLoader) throws MappingException {
        DatabaseRegistry.loadDatabase(new InputSource(string), null, null, classLoader);
    }

    public static void loadConfiguration(InputSource inputSource, EntityResolver entityResolver, ClassLoader classLoader) throws MappingException {
        DatabaseRegistry.loadDatabase(inputSource, entityResolver, null, classLoader);
    }

    public synchronized Reference getReference() {
        Reference reference = new Reference(this.getClass().getName(), this.getClass().getName(), null);
        if (this._description != null) {
            reference.add(new StringRefAddr("description", this._description));
        }
        if (this._dbName != null) {
            reference.add(new StringRefAddr("databaseName", this._dbName));
        }
        if (this._dbConf != null) {
            reference.add(new StringRefAddr("configuration", this._dbConf));
        }
        if (this._tmName != null) {
            reference.add(new StringRefAddr("transactionManager", this._tmName));
        }
        reference.add(new StringRefAddr("lockTimeout", Integer.toString(this._lockTimeout)));
        return reference;
    }

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws NamingException {
        if (object instanceof Reference) {
            Reference reference = (Reference)object;
            if (reference.getClassName().equals(this.getClass().getName())) {
                JDO jDO;
                try {
                    jDO = (JDO)Class.forName(reference.getClassName()).newInstance();
                }
                catch (Exception exception) {
                    throw new NamingException(exception.toString());
                }
                RefAddr refAddr = reference.get("description");
                if (refAddr != null) {
                    jDO._description = (String)refAddr.getContent();
                }
                if ((refAddr = reference.get("databaseName")) != null) {
                    jDO._dbName = (String)refAddr.getContent();
                }
                if ((refAddr = reference.get("configuration")) != null) {
                    jDO._dbConf = (String)refAddr.getContent();
                }
                if ((refAddr = reference.get("lockTimeout")) != null) {
                    jDO._lockTimeout = Integer.parseInt((String)refAddr.getContent());
                }
                if ((refAddr = reference.get("transactionManager")) != null) {
                    jDO._tmName = (String)refAddr.getContent();
                }
                return jDO;
            }
            throw new NamingException("JDO: Reference not constructed from class " + this.getClass().getName());
        }
        if (object instanceof Remote) {
            return object;
        }
        return null;
    }
}

