/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.tools;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.exolab.castor.builder.util.ConsoleDialog;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.loader.Types;
import org.exolab.castor.mapping.xml.BindXml;
import org.exolab.castor.mapping.xml.ClassMapping;
import org.exolab.castor.mapping.xml.FieldMapping;
import org.exolab.castor.mapping.xml.MapTo;
import org.exolab.castor.mapping.xml.MappingRoot;
import org.exolab.castor.mapping.xml.types.CollectionType;
import org.exolab.castor.mapping.xml.types.NodeType;
import org.exolab.castor.util.CommandLineOptions;
import org.exolab.castor.xml.Introspector;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.XMLFieldDescriptor;
import org.exolab.castor.xml.util.ClassDescriptorResolverImpl;

public class MappingTool {
    private Hashtable _mappings = new Hashtable();
    private ClassDescriptorResolverImpl _resolver = new ClassDescriptorResolverImpl();
    private Introspector _introspector = null;
    private boolean _forceIntrospection = false;

    public static void main(String[] stringArray) {
        boolean bl;
        CommandLineOptions commandLineOptions = new CommandLineOptions();
        commandLineOptions.addFlag("i", "classname", "Sets the input class");
        String string = "Sets the output mapping filename";
        commandLineOptions.addFlag("o", "filename", string, true);
        string = "Force overwriting of files.";
        commandLineOptions.addFlag("f", "", string, true);
        string = "Displays this help screen.";
        commandLineOptions.addFlag("h", "", string, true);
        Properties properties = commandLineOptions.getOptions(stringArray);
        if (properties.getProperty("h") != null) {
            PrintWriter printWriter = new PrintWriter(System.out, true);
            commandLineOptions.printHelp(printWriter);
            printWriter.flush();
            return;
        }
        String string2 = properties.getProperty("i");
        String string3 = properties.getProperty("o");
        boolean bl2 = bl = properties.getProperty("f") != null;
        if (string2 == null) {
            PrintWriter printWriter = new PrintWriter(System.out, true);
            commandLineOptions.printUsage(printWriter);
            printWriter.flush();
            return;
        }
        try {
            MappingTool mappingTool = new MappingTool();
            mappingTool.addClass(string2);
            Writer writer = null;
            if (string3 == null || string3.length() == 0) {
                writer = new PrintWriter(System.out, true);
            } else {
                String string4;
                ConsoleDialog consoleDialog;
                File file = new File(string3);
                if (file.exists() && !bl && !(consoleDialog = new ConsoleDialog()).confirm(string4 = "The file already exists. Do you wish to overwrite '" + string3 + "'?")) {
                    return;
                }
                writer = new FileWriter(file);
            }
            mappingTool.write(writer);
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
        }
    }

    public void addClass(String string) throws MappingException {
        this.addClass(string, true);
    }

    public void addClass(String string, boolean bl) throws MappingException {
        if (string == null) {
            throw new MappingException("Cannot introspect a null class.");
        }
        try {
            this.addClass(Class.forName(string), bl);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MappingException(classNotFoundException);
        }
    }

    public void addClass(Class clazz) throws MappingException {
        this.addClass(clazz, true);
    }

    public void addClass(Class clazz, boolean bl) throws MappingException {
        Class<?> clazz2;
        if (clazz == null) {
            throw new MappingException("Cannot introspect a null class.");
        }
        if (this._mappings.get(clazz) != null) {
            return;
        }
        if (clazz.isArray()) {
            clazz2 = clazz.getComponentType();
            if (this._mappings.get(clazz2) != null) {
                return;
            }
            if (Types.isSimpleType(clazz2)) {
                return;
            }
            this.addClass(clazz2);
        }
        if (this._forceIntrospection && !Types.isConstructable(clazz)) {
            throw new MappingException("mapping.classNotConstructable", clazz.getName());
        }
        try {
            clazz2 = this._forceIntrospection ? this._introspector.generateClassDescriptor(clazz) : this._resolver.resolve(clazz);
        }
        catch (MarshalException marshalException) {
            throw new MappingException(marshalException);
        }
        ClassMapping classMapping = new ClassMapping();
        classMapping.setName(clazz.getName());
        classMapping.setDescription("Default mapping for class " + clazz.getName());
        MapTo mapTo = new MapTo();
        mapTo.setXml(clazz2.getXMLName());
        mapTo.setNsUri(clazz2.getNameSpaceURI());
        mapTo.setNsPrefix(clazz2.getNameSpacePrefix());
        classMapping.setMapTo(mapTo);
        this._mappings.put(clazz, classMapping);
        FieldDescriptor[] fieldDescriptorArray = clazz2.getFields();
        int n = 0;
        while (n < fieldDescriptorArray.length) {
            FieldDescriptor fieldDescriptor = fieldDescriptorArray[n];
            FieldMapping fieldMapping = new FieldMapping();
            fieldMapping.setName(fieldDescriptor.getFieldName());
            Class<?> clazz3 = fieldDescriptor.getFieldType();
            boolean bl2 = clazz3.isArray();
            while (clazz3.isArray()) {
                clazz3 = clazz3.getComponentType();
            }
            fieldMapping.setType(clazz3.getName());
            if (fieldDescriptor.isRequired()) {
                fieldMapping.setRequired(true);
            }
            if (fieldDescriptor.isTransient()) {
                fieldMapping.setTransient(true);
            }
            if (fieldDescriptor.isMultivalued()) {
                if (bl2) {
                    fieldMapping.setCollection(CollectionType.ARRAY);
                } else {
                    fieldMapping.setCollection(CollectionType.ENUMERATE);
                }
            }
            fieldMapping.setBindXml(new BindXml());
            fieldMapping.getBindXml().setName(((XMLFieldDescriptor)fieldDescriptor).getXMLName());
            fieldMapping.getBindXml().setNode(NodeType.valueOf(((XMLFieldDescriptor)fieldDescriptorArray[n]).getNodeType().toString()));
            classMapping.addFieldMapping(fieldMapping);
            if (bl && this._mappings.get(clazz3) == null && !Types.isSimpleType(clazz3)) {
                this.addClass(clazz3);
            }
            ++n;
        }
    }

    public void setForceIntrospection(boolean bl) {
        this._forceIntrospection = bl;
        if (bl && this._introspector == null) {
            this._introspector = new Introspector();
        }
    }

    public void write(Writer writer) throws MappingException {
        try {
            MappingRoot mappingRoot = new MappingRoot();
            mappingRoot.setDescription("Castor generated mapping file");
            Enumeration enumeration = this._mappings.elements();
            while (enumeration.hasMoreElements()) {
                mappingRoot.addClassMapping((ClassMapping)enumeration.nextElement());
            }
            Marshaller marshaller = new Marshaller(writer);
            marshaller.marshal(mappingRoot);
        }
        catch (Exception exception) {
            throw new MappingException(exception);
        }
    }
}

