/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema;

import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.Form;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.SimpleTypeReference;

public final class AttributeDecl
extends Annotated {
    public static final String USE_OPTIONAL = "optional";
    public static final String USE_PROHIBITED = "prohibited";
    public static final String USE_REQUIRED = "required";
    private static final short OPTIONAL = 3;
    private static final short PROHIBITED = 4;
    private static final short REQUIRED = 5;
    private static String NULL_ARGUMENT = "A null argument was passed to the constructor of " + (class$org$exolab$castor$xml$schema$AttributeDecl == null ? (class$org$exolab$castor$xml$schema$AttributeDecl = AttributeDecl.class$("org.exolab.castor.xml.schema.AttributeDecl")) : class$org$exolab$castor$xml$schema$AttributeDecl).getName();
    private boolean _default = false;
    private boolean _fixed = false;
    private Form _form = null;
    private String _id = null;
    private String _name = null;
    private Schema _schema = null;
    private SimpleType _simpleType = null;
    private short _useFlag = (short)3;
    private String _value = null;
    private String _attributeRef = null;
    static /* synthetic */ Class class$org$exolab$castor$xml$schema$AttributeDecl;

    public AttributeDecl(Schema schema, String string) {
        if (schema == null) {
            String string2 = NULL_ARGUMENT + "; 'schema' must not be null.";
            throw new IllegalArgumentException(string2);
        }
        this._schema = schema;
        this.setName(string);
    }

    public AttributeDecl(Schema schema) {
        if (schema == null) {
            String string = NULL_ARGUMENT + "; 'schema' must not be null.";
            throw new IllegalArgumentException(string);
        }
        this._schema = schema;
    }

    public Form getForm() {
        return this._form;
    }

    public String getId() {
        return this._id;
    }

    public String getName() {
        return this.getName(false);
    }

    public String getName(boolean bl) {
        if (this.isReference() && !bl) {
            return this._attributeRef;
        }
        return this._name;
    }

    public SimpleType getSimpleType() {
        if (this._simpleType == null) {
            return null;
        }
        return (SimpleType)this._simpleType.getType();
    }

    public AttributeDecl getReference() {
        if (this._attributeRef != null) {
            return this._schema.getAttribute(this._attributeRef);
        }
        return null;
    }

    public Schema getSchema() {
        return this._schema;
    }

    public String getUse() {
        switch (this._useFlag) {
            case 4: {
                return USE_PROHIBITED;
            }
            case 5: {
                return USE_REQUIRED;
            }
        }
        return USE_OPTIONAL;
    }

    public String getValue() {
        return this._value;
    }

    public boolean isDefault() {
        return this._default;
    }

    public boolean isFixed() {
        return this._fixed;
    }

    public boolean isOptional() {
        return this._useFlag == 3;
    }

    public boolean isProhibited() {
        return this._useFlag == 4;
    }

    public boolean isRequired() {
        return this._value == null && this._useFlag == 5;
    }

    public boolean isReference() {
        return this._attributeRef != null;
    }

    public void setForm(Form form) {
        this._form = form;
    }

    public void setId(String string) {
        this._id = string;
    }

    public void setName(String string) {
        String string2;
        if (string == null) {
            String string3 = "AttributeDecl#setName: 'name' must not be null.";
            throw new IllegalArgumentException(string3);
        }
        int n = string.indexOf(58);
        if (n >= 0) {
            string2 = string.substring(0, n);
            string = string.substring(n + 1);
        }
        if (string.length() == 0) {
            string2 = "AttributeDecl#setName: 'name' must not be zero-length.";
            throw new IllegalArgumentException(string2);
        }
        this._name = string;
    }

    public void setReference(AttributeDecl attributeDecl) {
        this._attributeRef = attributeDecl == null ? null : attributeDecl.getName();
    }

    public void setReference(String string) {
        this._attributeRef = string;
    }

    public void setSimpleType(SimpleType simpleType) {
        this._simpleType = simpleType;
        if (simpleType != null) {
            simpleType.setParent(this);
        }
    }

    public void setSimpleTypeReference(String string) {
        SimpleTypeReference simpleTypeReference = new SimpleTypeReference(this._schema, string);
        this.setSimpleType(simpleTypeReference);
    }

    public void setUse(String string) {
        if (string == null) {
            this._useFlag = (short)3;
            return;
        }
        if (string.equals(USE_REQUIRED)) {
            this._useFlag = (short)5;
        } else if (string.equals(USE_OPTIONAL)) {
            this._useFlag = (short)3;
        } else if (string.equals(USE_PROHIBITED)) {
            this._useFlag = (short)4;
        } else {
            throw new IllegalArgumentException("Invalid value for 'use': " + string);
        }
    }

    public void setDefault() {
        this._default = true;
    }

    public void setFixed() {
        this._fixed = true;
    }

    public void setValue(String string) {
        this._value = string;
    }

    public short getStructureType() {
        return 2;
    }

    public void validate() throws ValidationException {
        if (this._attributeRef == null && this._name == null) {
            String string = "<attribute> is missing required 'name' attribute.";
            throw new ValidationException(string);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

