/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema;

import java.util.Enumeration;
import java.util.Vector;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.IdentityField;
import org.exolab.castor.xml.schema.IdentitySelector;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.validators.ValidationUtils;

public abstract class IdentityConstraint
extends Annotated {
    private String _id = null;
    private String _name = null;
    private IdentitySelector _selector = null;
    private Vector _fields = null;

    protected IdentityConstraint(String string) throws SchemaException {
        this.setName(string);
        this._fields = new Vector(3);
    }

    public void addField(IdentityField identityField) {
        if (identityField != null) {
            this._fields.addElement(identityField);
        }
    }

    public Enumeration getFields() {
        return this._fields.elements();
    }

    public String getId() {
        return this._id;
    }

    public String getName() {
        return this._name;
    }

    public IdentitySelector getSelector() {
        return this._selector;
    }

    public boolean removeField(IdentityField identityField) {
        return this._fields.removeElement(identityField);
    }

    public void setId(String string) {
        this._id = string;
    }

    public void setName(String string) throws SchemaException {
        if (string == null) {
            throw new SchemaException("The name of an IdentityConstraint must not be null.");
        }
        this._name = string;
    }

    public void setSelector(IdentitySelector identitySelector) throws SchemaException {
        if (identitySelector == null) {
            throw new SchemaException("The selector of an IdentityConstraint must not be null.");
        }
        this._selector = identitySelector;
    }

    public abstract short getStructureType();

    public void validate() throws ValidationException {
        String string = null;
        if (!ValidationUtils.isNCName(this._name)) {
            string = "The name of an IdentityConstraint must be an NCName.";
        } else if (this._selector == null) {
            string = "Selector for IdentityConstraint cannot be null.";
        } else if (this._fields.size() < 1) {
            string = "There must be at least one 'field' in an identity constraint.";
        }
        if (string != null) {
            throw new ValidationException(string);
        }
    }
}

