/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.IdentityConstraint;
import org.exolab.castor.xml.schema.IdentityField;
import org.exolab.castor.xml.schema.IdentitySelector;
import org.exolab.castor.xml.schema.Key;
import org.exolab.castor.xml.schema.KeyRef;
import org.exolab.castor.xml.schema.Unique;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.FieldOrSelectorUnmarshaller;
import org.exolab.castor.xml.schema.reader.SaxUnmarshaller;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class IdentityConstraintUnmarshaller
extends SaxUnmarshaller {
    private SaxUnmarshaller _unmarshaller;
    private int _depth = 0;
    private IdentityConstraint _identityConstraint = null;
    private boolean _foundAnnotation = false;
    private boolean _foundSelector = false;
    private boolean _foundField = false;
    private String _elementName = null;

    public IdentityConstraintUnmarshaller(String string, AttributeList attributeList) throws SAXException {
        this._elementName = string;
        String string2 = attributeList.getValue("name");
        if (string2 == null) {
            this.error("The 'name' attribute for an identity-constraint must exist.");
        }
        String string3 = attributeList.getValue("id");
        if ("keyref".equals(string)) {
            String string4 = attributeList.getValue("refer");
            if (string4 == null) {
                this.error("The 'refer' attribute for keyref must exist.");
            }
            this._identityConstraint = new KeyRef(string2, string4);
        } else {
            this._identityConstraint = "unique".equals(string) ? new Unique(string2) : new Key(string2);
        }
    }

    public String elementName() {
        return this._elementName;
    }

    public IdentityConstraint getIdentityConstraint() {
        return this._identityConstraint;
    }

    public Object getObject() {
        return this.getIdentityConstraint();
    }

    public void finish() throws SAXException {
        if (!this._foundSelector) {
            this.error("Invalid " + this._elementName + "; missing 'selector'.");
        } else if (!this._foundField) {
            this.error("Invalid " + this._elementName + "; missing 'field'.");
        }
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if (this._unmarshaller != null) {
            this._unmarshaller.startElement(string, attributeList);
            ++this._depth;
            return;
        }
        if ("annotation".equals(string)) {
            if (this._foundAnnotation) {
                this.error("Only one (1) annotation may appear as a child of '" + this._elementName + "'.");
            }
            if (this._foundSelector || this._foundField) {
                this.error("An annotation may only appear as the first child of '" + this._elementName + "'.");
            }
            this._foundAnnotation = true;
            this._unmarshaller = new AnnotationUnmarshaller(attributeList);
        } else if ("selector".equals(string)) {
            if (this._foundField) {
                String string2 = "The 'selector' element of '" + this._elementName + "' must appear before any 'field' elements.";
                this.error(string2);
            }
            if (this._foundSelector) {
                this.error("Only one (1) 'selector' may appear as a child of '" + this._elementName + "'.");
            }
            this._foundSelector = true;
            this._unmarshaller = new FieldOrSelectorUnmarshaller(string, attributeList);
        } else if ("field".equals(string)) {
            this._foundField = true;
            this._unmarshaller = new FieldOrSelectorUnmarshaller(string, attributeList);
        } else {
            this.illegalElement(string);
        }
    }

    public void endElement(String string) throws SAXException {
        if (this._unmarshaller != null && this._depth > 0) {
            this._unmarshaller.endElement(string);
            --this._depth;
            return;
        }
        this._unmarshaller.finish();
        if ("annotation".equals(string)) {
            Annotation annotation = (Annotation)this._unmarshaller.getObject();
            this._identityConstraint.addAnnotation(annotation);
        } else if ("selector".equals(string)) {
            IdentitySelector identitySelector = (IdentitySelector)this._unmarshaller.getObject();
            this._identityConstraint.setSelector(identitySelector);
        } else if ("field".equals(string)) {
            IdentityField identityField = (IdentityField)this._unmarshaller.getObject();
            this._identityConstraint.addField(identityField);
        }
        this._unmarshaller = null;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this._unmarshaller != null) {
            this._unmarshaller.characters(cArray, n, n2);
        }
    }
}

