/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.collectors.vmware;

import com.netapp.collectors.vmware.exceptions.VMWareCertificateException;
import com.netapp.collectors.vmware.exceptions.VMWareConnectionException;
import com.netapp.collectors.vmware.logger.LogsManager;
import com.onaro.commons.framework.mgmt.CertificateDownloadingService;
import com.vmware.vim25.InvalidLocaleFaultMsg;
import com.vmware.vim25.InvalidLoginFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.ServiceContent;
import com.vmware.vim25.VimPortType;
import com.vmware.vim25.VimService;
import java.io.IOException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.ws.BindingProvider;
import org.slf4j.Logger;

public class ServiceConnection25 {
    public static int ConnectionState_Connected = 0;
    public static int ConnectionState_Disconnected = 1;
    protected VimPortType service;
    protected int serviceState;
    protected ServiceContent serviceContent;
    protected ManagedObjectReference serviceReference;
    private static final Logger LOGGER = LogsManager.getLogger(ServiceConnection25.class);
    HostnameVerifier hv = new HostnameVerifier(){

        @Override
        public boolean verify(String s, SSLSession sslSession) {
            return false;
        }
    };

    public ServiceConnection25() {
        this.serviceState = ConnectionState_Disconnected;
        this.serviceReference = new ManagedObjectReference();
        this.serviceReference.setType("ServiceInstance");
        this.serviceReference.setValue("ServiceInstance");
    }

    public void connect(String urlStr, String username, String password, boolean ignoreCerts) throws NoSuchAlgorithmException, KeyManagementException, VMWareConnectionException, VMWareCertificateException {
        this.connect(urlStr, username, password, 0, ignoreCerts);
    }

    public void connect(String urlStr, String username, String password, int sslConnectionTimeout, boolean ignoreCerts) throws VMWareConnectionException, VMWareCertificateException {
        if (this.service != null) {
            this.disconnect();
        }
        try {
            this.connectToVCenter(urlStr, username, password, false);
        }
        catch (VMWareConnectionException ex) {
            this.handleCertificates(urlStr, ignoreCerts, sslConnectionTimeout);
            this.connectToVCenter(urlStr, username, password, true);
        }
    }

    private void connectToVCenter(String urlStr, String username, String password, boolean logError) throws VMWareConnectionException {
        try {
            VimPortType vimPort;
            VimService vimService = new VimService();
            this.service = vimPort = vimService.getVimPort();
            Map<String, Object> ctxt = ((BindingProvider)((Object)vimPort)).getRequestContext();
            ctxt.put("javax.xml.ws.service.endpoint.address", urlStr);
            ctxt.put("javax.xml.ws.session.maintain", true);
            this.serviceContent = vimPort.retrieveServiceContent(this.serviceReference);
            vimPort.login(this.serviceContent.getSessionManager(), username, password, null);
            this.serviceState = ConnectionState_Connected;
        }
        catch (RuntimeFaultFaultMsg runtimeFaultFaultMsg) {
            LOGGER.error(String.format("Error while connecting to the VCenter url %s user %s", urlStr, username), runtimeFaultFaultMsg);
            throw new VMWareConnectionException(String.format("Error while connecting to the vcenter url %s user %s", urlStr, username));
        }
        catch (InvalidLocaleFaultMsg invalidLocaleFaultMsg) {
            LOGGER.error(String.format("Invalid locale information VCenter url %s user %s", urlStr, username), invalidLocaleFaultMsg);
            throw new VMWareConnectionException(String.format("Invalid locale information vcenter url %s user %s", urlStr, username));
        }
        catch (InvalidLoginFaultMsg invalidLoginFaultMsg) {
            LOGGER.error(String.format("%s VCenter url %s user %s", "Invalid login credentials", urlStr, username), invalidLoginFaultMsg);
            throw new VMWareConnectionException("Invalid login credentials");
        }
        catch (Exception e) {
            if (logError) {
                LOGGER.error(String.format("connection to  VCenter url %s user %s failed !", urlStr, username), e);
                throw new VMWareConnectionException(String.format("connection failure:  %s user %s", urlStr, username));
            }
            LOGGER.warn(String.format("Connection to VCenter url %s user %s failed. Retrying with proper certificate...", urlStr, username));
            throw new VMWareConnectionException(String.format("connection failure:  %s user %s", urlStr, username));
        }
    }

    private void handleCertificates(String url, boolean ignoreCerts, int sslConnectionTimeout) throws VMWareCertificateException {
        if (ignoreCerts) {
            this.trustAllCertificates();
        } else {
            this.downloadCertificatesIfNecessary(url, sslConnectionTimeout);
        }
    }

    private void trustAllCertificates() {
        this.ignoreCert();
        try {
            this.trustCertificates();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Error while ignoring the certificate. Reason - " + e.getMessage());
        }
    }

    private void trustCertificates() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustAllCerts = new TrustManager[1];
        TrustAllTrustManager tm = new TrustAllTrustManager();
        trustAllCerts[0] = tm;
        SSLContext sc = SSLContext.getInstance("SSL");
        SSLSessionContext sslsc = sc.getServerSessionContext();
        sslsc.setSessionTimeout(0);
        sc.init(null, trustAllCerts, null);
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HttpsURLConnection.setDefaultHostnameVerifier(this.hv);
    }

    private void downloadCertificatesIfNecessary(String urlString, int sslConnectionTimeout) throws VMWareCertificateException {
        try {
            URL url = new URL(urlString);
            CertificateDownloadingService certificateDownloadingService = CertificateDownloadingService.getInstance();
            certificateDownloadingService.downloadCertificates(url, sslConnectionTimeout);
        }
        catch (IOException | CertificateException exception) {
            String errMessage = String.format("Exception during certificate download for URL - %s", urlString);
            LOGGER.error(errMessage, exception);
            throw new VMWareCertificateException(errMessage);
        }
    }

    private void ignoreCert() {
        System.setProperty("org.apache.axis.components.net.SecureSocketFactory", "org.apache.axis.components.net.SunFakeTrustSocketFactory");
    }

    public boolean isConnected() {
        return this.serviceState == ConnectionState_Connected;
    }

    public VimPortType getService() {
        return this.service;
    }

    public ManagedObjectReference getServiceInstanceRef() {
        return this.serviceReference;
    }

    public ServiceContent getServiceContent() {
        return this.serviceContent;
    }

    public ManagedObjectReference getPropCol() {
        return this.serviceContent.getPropertyCollector();
    }

    public ManagedObjectReference getRootFolder() {
        return this.serviceContent.getRootFolder();
    }

    public int getServiceState() {
        return this.serviceState;
    }

    public void disconnect() {
        try {
            this.getService().logout(this.getServiceContent().getSessionManager());
        }
        catch (RuntimeFaultFaultMsg runtimeFaultFaultMsg) {
            throw new RuntimeException("Failed while disconnecting from vim service");
        }
    }

    private static class TrustAllTrustManager
    implements TrustManager,
    X509TrustManager {
        private TrustAllTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public boolean isServerTrusted(X509Certificate[] certs) {
            return true;
        }

        public boolean isClientTrusted(X509Certificate[] certs) {
            return true;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }
    }
}

