/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.collectors.vmware;

import com.netapp.collectors.vmware.IVMWare25Dao;
import com.netapp.collectors.vmware.IVMWareContext;
import com.netapp.collectors.vmware.exceptions.InvalidPropertyException;
import com.netapp.collectors.vmware.logger.LogsManager;
import com.netapp.collectors.vmware.util.ContextUtil;
import com.netapp.collectors.vmware.util.SpecBuilderUtil;
import com.vmware.vim25.ArrayOfPerfCounterInfo;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.PerfCounterInfo;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RetrieveResult;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.SelectionSpec;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;

public class VMWare25Dao
implements IVMWare25Dao {
    private static final Logger logger = LogsManager.getLogger(VMWare25Dao.class);

    public Map<String, Map<?, ?>> retrieveAvailablePerfMetricMaps(IVMWareContext context) {
        List<PropertySpec> perfPropSpec;
        HashMap availablePerMetricMap = new HashMap();
        HashMap<CallSite, Integer> metricsCounterToIdMap = new HashMap<CallSite, Integer>();
        HashMap<Integer, PerfCounterInfo> metricsIdToCounterInfoMap = new HashMap<Integer, PerfCounterInfo>();
        ManagedObjectReference perfManager = (ManagedObjectReference)context.getPerformanceManager();
        RetrieveResult perfResult = this.retrieveManagedObjectsAndProperties(perfManager, perfPropSpec = SpecBuilderUtil.buildPerfCounterSpec(perfManager), false, context);
        List<ObjectContent> objectContents = perfResult.getObjects();
        if (CollectionUtils.isNotEmpty(objectContents) && objectContents.size() == 1) {
            ArrayOfPerfCounterInfo perfCounterInfoArray = (ArrayOfPerfCounterInfo)objectContents.get(0).getPropSet().get(0).getVal();
            List<PerfCounterInfo> perfCounterInfoList = perfCounterInfoArray.getPerfCounterInfo();
            for (int i = 0; i < perfCounterInfoList.size(); ++i) {
                String key = perfCounterInfoList.get(i).getGroupInfo().getKey() + "." + perfCounterInfoList.get(i).getNameInfo().getKey() + "." + perfCounterInfoList.get(i).getRollupType().value();
                Integer value = new Integer(perfCounterInfoList.get(i).getKey());
                metricsCounterToIdMap.put((CallSite)((Object)key), value);
                metricsIdToCounterInfoMap.put(value, perfCounterInfoList.get(i));
                logger.debug("Available perf counters: " + key + " - " + metricsIdToCounterInfoMap.get(value));
            }
            availablePerMetricMap.put("metricsCounterMap", metricsCounterToIdMap);
            availablePerMetricMap.put("counterInfoMap", metricsIdToCounterInfoMap);
        } else {
            logger.error("Perf counter details are not available from vCenter {}", (Object)context.getVcURL());
        }
        return availablePerMetricMap;
    }

    public RetrieveResult retrieveManagedObjectsAndProperties(ManagedObjectReference managedObjectReference, List<PropertySpec> propertySpec, boolean b, IVMWareContext context) {
        return VMWare25Dao.retrieveManagedObjectsAndProperties(managedObjectReference, propertySpec, SpecBuilderUtil.buildFullTraversal(), false, context, null, null);
    }

    public static RetrieveResult retrieveManagedObjectsAndProperties(ManagedObjectReference mor, List<PropertySpec> pSpec, List<SelectionSpec> tSpec, boolean skipRoot, IVMWareContext context, Integer maxRecords, String nextToken) {
        ArrayList<ObjectSpec> obSpecList = new ArrayList<ObjectSpec>();
        ObjectSpec objectSpec = new ObjectSpec();
        objectSpec.setObj(mor);
        objectSpec.setSkip(skipRoot);
        objectSpec.getSelectSet().addAll(tSpec);
        obSpecList.add(objectSpec);
        return VMWare25Dao.retrieveManagedObjectsAndProperties(obSpecList, pSpec, skipRoot, context, maxRecords, nextToken);
    }

    private static RetrieveResult retrieveManagedObjectsAndProperties(List<ObjectSpec> obSpec, List<PropertySpec> pSpec, boolean skipRoot, IVMWareContext context, Integer maxRecords, String nextToken) {
        PropertyFilterSpec fSpec = new PropertyFilterSpec();
        fSpec.getObjectSet().addAll(obSpec);
        fSpec.getPropSet().addAll(pSpec);
        ArrayList<PropertyFilterSpec> fSpecList = new ArrayList<PropertyFilterSpec>();
        fSpecList.add(fSpec);
        RetrieveOptions retrieveOptions = new RetrieveOptions();
        if (maxRecords != null) {
            retrieveOptions.setMaxObjects(maxRecords);
        }
        try {
            if (nextToken == null) {
                return ContextUtil.getVimPortService(context).retrievePropertiesEx((ManagedObjectReference)context.getPropertyCollector(), fSpecList, retrieveOptions);
            }
            return ContextUtil.getVimPortService(context).continueRetrievePropertiesEx((ManagedObjectReference)context.getPropertyCollector(), nextToken);
        }
        catch (InvalidPropertyFaultMsg invalidPropertyFaultMsg) {
            throw new InvalidPropertyException(invalidPropertyFaultMsg.getMessage());
        }
        catch (RuntimeFaultFaultMsg runtimeFaultFaultMsg) {
            throw new RuntimeException(runtimeFaultFaultMsg.getMessage());
        }
    }
}

