/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.collectors.vmware;

import com.netapp.collectors.vmware.IVMWareContext;
import com.netapp.collectors.vmware.IVMWareService;
import com.netapp.collectors.vmware.ServiceConnection25;
import com.netapp.collectors.vmware.VMWare25Context;
import com.netapp.collectors.vmware.builders.PropertySpecBuilder;
import com.netapp.collectors.vmware.exceptions.CommunicationStateReason;
import com.netapp.collectors.vmware.exceptions.InvalidPropertyException;
import com.netapp.collectors.vmware.exceptions.VMWareCertificateException;
import com.netapp.collectors.vmware.exceptions.VMWareConnectionException;
import com.netapp.collectors.vmware.exceptions.VMWareServiceException;
import com.netapp.collectors.vmware.logger.LogsManager;
import com.netapp.collectors.vmware.util.ContextUtil;
import com.netapp.collectors.vmware.util.SpecBuilderUtil;
import com.netapp.collectors.vmware.util.TimeUtil;
import com.netapp.collectors.vmware.util.VMWareDataFetcher;
import com.vmware.vim25.ArrayOfOptionValue;
import com.vmware.vim25.DynamicProperty;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.OptionValue;
import com.vmware.vim25.Permission;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RetrieveResult;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.SelectionSpec;
import com.vmware.vim25.ServiceContent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.XMLGregorianCalendar;
import org.slf4j.Logger;

public class VMWare25Service
implements IVMWareService {
    private static final Logger logger = LogsManager.getLogger(VMWare25Service.class);
    private static final String ERR_NO_UUID_BY_MANAGED_OBJECT_REFERENCE = "Uuid does not exist in uuid to managed object reference map based on the key {0} from access handle id: {1}.";
    protected static final String MSG_HOST_DOESNT_SUPPORT_DATASTORE_STATS = "Host {0} does not support datastore stats counters, skipping query for datastore stats";
    protected static final String MSG_HOST_DOESNT_SUPPORT_VIRTUALDISK_STATS = "Host {0} does not support virtualDisk stats counters, skipping query for virtualDisk stats";
    private static final String ERR_NULL_UUID = "Uuid is null for AH = {0} MOR = {1}";
    public static final String MSG_NETWORK_ERROR = "A network error occurred. This could be caused by a network problem or service no longer responding.";
    public static final String OBJECT_NOT_CREATED_ERROR = "object has already been deleted or has not been completely created";
    public static final String MSG_OBJECT_DELETED_OR_NOT_FULLY_CREATED = "Error querying object because it has already been deleted or has not been completely created.";
    public static final String VIM_25_PACKAGE = "com.vmware.vim25";
    private static volatile VMWare25Service vmware25Service;
    private String virtualCenterUrl;
    private Map<Long, Map<Object, String>> virtualCenterUuidToMoRefMap = Collections.synchronizedMap(new HashMap());

    public String getVirtualCenterUrl() {
        return this.virtualCenterUrl;
    }

    public void setVirtualCenterUrl(String virtualCenterUrl) {
        this.virtualCenterUrl = virtualCenterUrl;
    }

    protected VMWare25Service() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VMWare25Service getInstance() {
        if (vmware25Service != null) return vmware25Service;
        Class<VMWare25Service> clazz = VMWare25Service.class;
        synchronized (VMWare25Service.class) {
            if (vmware25Service != null) return vmware25Service;
            vmware25Service = new VMWare25Service();
            // ** MonitorExit[var0] (shouldn't be in output)
            return vmware25Service;
        }
    }

    @Override
    public IVMWareContext connectAndGetContext(String userName, String password, String serviceURL, String hostNameOrIp, boolean ignoreCertificate, String deviceType, long accessHandleId, int sslConnectionTimeout) throws VMWareConnectionException, VMWareCertificateException, VMWareServiceException {
        boolean isEmbeddedEsx = false;
        boolean isEsx = false;
        ServiceConnection25 serviceConnection = null;
        ServiceContent serviceContent = null;
        Integer vcInstanceId = null;
        try {
            serviceConnection = new ServiceConnection25();
            serviceConnection.connect(serviceURL, userName, password, sslConnectionTimeout, ignoreCertificate);
            serviceContent = serviceConnection.getServiceContent();
            List<OptionValue> optionValues = VMWareDataFetcher.retrieveServiceContentSettings(new VMWare25Context(serviceConnection, serviceContent, accessHandleId));
            if (optionValues == null) {
                ManagedObjectReference authorizationManager = serviceContent.getAuthorizationManager();
                List<Permission> permissions = serviceConnection.getService().retrieveAllPermissions(authorizationManager);
                List<Permission> permissionsWithUserName = this.getPermissionsContainingUserName(userName, permissions);
                List<Permission> permissionsWithRootLevelEntity = this.getPermissionsContainedInFolder(serviceContent.getRootFolder(), permissionsWithUserName);
                if (permissionsWithRootLevelEntity.size() == 0) {
                    throw new VMWareConnectionException(CommunicationStateReason.PERMISSION_DENIED, "User with the name " + userName + " may not have been assigned privileges at the root level.");
                }
            }
            if (deviceType.equals("VIRTUAL_CENTER")) {
                for (OptionValue optionValue : optionValues) {
                    if (!optionValue.getKey().equals("instance.id")) continue;
                    vcInstanceId = (Integer)optionValue.getValue();
                }
                if (vcInstanceId == null) {
                    throw new VMWareServiceException("Failed to retrieve Virtual Center instance Id for device");
                }
                logger.debug("Retrieved the VC instance id {}", (Object)vcInstanceId);
            }
        }
        catch (Exception ex) {
            logger.error(String.format("Error while connecting to VCenter %s", hostNameOrIp));
            throw new VMWareConnectionException(ex);
        }
        XMLGregorianCalendar now = this.getCurrentTime(serviceConnection);
        logger.debug("Current timestamp for context: " + TimeUtil.fromXMLGregorianCalendar(now).getTimeInMillis());
        VMWare25Context vmwareContext = deviceType.equals("VIRTUAL_CENTER") ? new VMWare25Context(serviceConnection, serviceContent, VIM_25_PACKAGE, isEmbeddedEsx, isEsx, vcInstanceId, accessHandleId, now, serviceURL, hostNameOrIp) : new VMWare25Context(serviceConnection, serviceContent, VIM_25_PACKAGE, isEmbeddedEsx, isEsx, accessHandleId, now);
        return vmwareContext;
    }

    public static RetrieveResult retrieveAllVmDetails(IVMWareContext vmWareContext) {
        ManagedObjectReference propertyCollector = (ManagedObjectReference)vmWareContext.getPropertyCollector();
        ManagedObjectReference containerViewReference = VMWare25Service.createContainerView(vmWareContext, "VirtualMachine");
        PropertyFilterSpec filterSpec = new PropertyFilterSpec();
        filterSpec.getObjectSet().addAll(SpecBuilderUtil.buildObjectSetForVm(containerViewReference));
        filterSpec.getPropSet().addAll(SpecBuilderUtil.buildPropertySetForVm());
        ArrayList<PropertyFilterSpec> propertyFilterSpecList = new ArrayList<PropertyFilterSpec>();
        propertyFilterSpecList.add(filterSpec);
        RetrieveOptions ro = new RetrieveOptions();
        try {
            return ContextUtil.getVimPortService(vmWareContext).retrievePropertiesEx(propertyCollector, propertyFilterSpecList, ro);
        }
        catch (InvalidPropertyFaultMsg invalidPropertyFaultMsg) {
            throw new RuntimeException("Error while fetching data - invalid property " + invalidPropertyFaultMsg.getMessage());
        }
        catch (RuntimeFaultFaultMsg runtimeFaultFaultMsg) {
            throw new RuntimeException("Error while fetching data - server error" + runtimeFaultFaultMsg.getMessage());
        }
    }

    public static RetrieveResult retrieveManagedObjectsAndProperties(ManagedObjectReference mor, List<PropertySpec> pSpec, List<SelectionSpec> tSpec, boolean skipRoot, IVMWareContext context, Integer maxRecords, String nextToken) {
        ArrayList<ObjectSpec> obSpecList = new ArrayList<ObjectSpec>();
        ObjectSpec objectSpec = new ObjectSpec();
        objectSpec.setObj(mor);
        objectSpec.setSkip(skipRoot);
        objectSpec.getSelectSet().addAll(tSpec);
        obSpecList.add(objectSpec);
        return VMWare25Service.retrieveManagedObjectsAndProperties(obSpecList, pSpec, skipRoot, context, maxRecords, nextToken);
    }

    private static RetrieveResult retrieveManagedObjectsAndProperties(List<ObjectSpec> obSpec, List<PropertySpec> pSpec, boolean skipRoot, IVMWareContext context, Integer maxRecords, String nextToken) {
        PropertyFilterSpec fSpec = new PropertyFilterSpec();
        fSpec.getObjectSet().addAll(obSpec);
        fSpec.getPropSet().addAll(pSpec);
        ArrayList<PropertyFilterSpec> fSpecList = new ArrayList<PropertyFilterSpec>();
        fSpecList.add(fSpec);
        RetrieveOptions retrieveOptions = new RetrieveOptions();
        if (maxRecords != null) {
            retrieveOptions.setMaxObjects(maxRecords);
        }
        try {
            if (nextToken == null) {
                return ContextUtil.getVimPortService(context).retrievePropertiesEx((ManagedObjectReference)context.getPropertyCollector(), fSpecList, retrieveOptions);
            }
            return ContextUtil.getVimPortService(context).continueRetrievePropertiesEx((ManagedObjectReference)context.getPropertyCollector(), nextToken);
        }
        catch (InvalidPropertyFaultMsg invalidPropertyFaultMsg) {
            throw new InvalidPropertyException(invalidPropertyFaultMsg.getMessage());
        }
        catch (RuntimeFaultFaultMsg runtimeFaultFaultMsg) {
            throw new RuntimeException(runtimeFaultFaultMsg.getMessage());
        }
    }

    public static List<OptionValue> retreiveServiceContentSettings(VMWare25Context vmWare25Context) {
        ManagedObjectReference optionManager = ((ServiceContent)vmWare25Context.getServiceContent()).getSetting();
        if (optionManager != null) {
            ArrayList<PropertySpec> pSpec = new ArrayList<PropertySpec>();
            PropertySpecBuilder serviceContentPropSet = new PropertySpecBuilder().all(Boolean.FALSE).addToPathSet(Arrays.asList("setting")).type(optionManager.getType());
            pSpec.add(serviceContentPropSet);
            ArrayList<ObjectSpec> oSpec = new ArrayList<ObjectSpec>();
            ObjectSpec serviceContentObjectSpec = new ObjectSpec();
            serviceContentObjectSpec.setObj(optionManager);
            oSpec.add(serviceContentObjectSpec);
            RetrieveResult retrieveResult = VMWare25Service.retrieveManagedObjectsAndProperties(oSpec, pSpec, false, vmWare25Context, null, null);
            for (ObjectContent objectContent : retrieveResult.getObjects()) {
                List<DynamicProperty> propSet = objectContent.getPropSet();
                if (propSet == null) continue;
                for (DynamicProperty dynamicProperty : propSet) {
                    if (!dynamicProperty.getName().equals("setting")) continue;
                    ArrayOfOptionValue vals = (ArrayOfOptionValue)dynamicProperty.getVal();
                    return vals.getOptionValue();
                }
            }
        }
        return null;
    }

    private static ManagedObjectReference createContainerView(IVMWareContext vmWareContext, String objectType) {
        ManagedObjectReference viewManagerReference = ContextUtil.getViewManagerReference(vmWareContext);
        ArrayList<String> typeList = new ArrayList<String>();
        typeList.add(objectType);
        try {
            return ContextUtil.getVimPortService(vmWareContext).createContainerView(viewManagerReference, ContextUtil.getRootFolder(vmWareContext), typeList, true);
        }
        catch (RuntimeFaultFaultMsg runtimeFaultFaultMsg) {
            throw new RuntimeException("Error while creating the container view" + runtimeFaultFaultMsg.getMessage());
        }
    }

    private List<Permission> getPermissionsContainedInFolder(ManagedObjectReference folder, List<Permission> permissions) {
        ArrayList<Permission> permissionsWithGivenLevelEntity = new ArrayList<Permission>();
        for (Permission permission : permissions) {
            if (!permission.getEntity().equals(folder)) continue;
            permissionsWithGivenLevelEntity.add(permission);
        }
        return permissionsWithGivenLevelEntity;
    }

    private XMLGregorianCalendar getCurrentTime(ServiceConnection25 svc) {
        XMLGregorianCalendar now = null;
        ManagedObjectReference svcRef = svc.getServiceInstanceRef();
        try {
            now = svc.getService().currentTime(svcRef);
        }
        catch (RuntimeFaultFaultMsg runtimeFaultFaultMsg) {
            runtimeFaultFaultMsg.printStackTrace();
        }
        return now;
    }

    private List<Permission> getPermissionsContainingUserName(String userName, List<Permission> permissions) {
        ArrayList<Permission> permissionsWithUserName = new ArrayList<Permission>();
        for (Permission permission : permissions) {
            String principal = permission.getPrincipal();
            if (!userName.equals(principal)) continue;
            permissionsWithUserName.add(permission);
        }
        return permissionsWithUserName;
    }
}

