/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.oci.profiler;

import com.netapp.oci.profiler.NoOpProfilerService;
import com.netapp.oci.profiler.ProfilerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfilerServiceFactory {
    private static final ProfilerService instance;
    private static final Logger logger;

    private ProfilerServiceFactory() {
    }

    public static ProfilerService getInstance() {
        return instance;
    }

    static {
        ProfilerService profilerService;
        String className = System.getProperty("profiler.class");
        logger = LoggerFactory.getLogger(ProfilerServiceFactory.class);
        if (className != null) {
            try {
                profilerService = (ProfilerService)Class.forName(className).newInstance();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), e);
                profilerService = new NoOpProfilerService();
            }
        } else {
            profilerService = new NoOpProfilerService();
        }
        instance = profilerService;
    }
}

