/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.common.ansi;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.netapp.common.ansi.AnsiColor;
import com.netapp.common.ansi.AnsiStyle;
import java.util.Arrays;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class AnsiFormat {
    private static final char ESC = '\u001b';
    private final AnsiColor foreground;
    private final AnsiColor background;
    private final AnsiStyle style;
    private final String prefix;
    private final String suffix;

    public AnsiFormat(AnsiColor foreground, AnsiColor background, AnsiStyle style) {
        this.foreground = foreground;
        this.background = background;
        this.style = style;
        String attrs = Joiner.on((char)';').join(Iterables.filter(Arrays.asList(this.foreground == null ? null : Integer.valueOf(this.foreground.foregroundCode()), this.background == null ? null : Integer.valueOf(this.background.backgroundCode()), this.style == null ? null : Integer.valueOf(this.style.code())), (Predicate)Predicates.not((Predicate)Predicates.isNull())));
        this.prefix = "\u001b[" + attrs + "m";
        this.suffix = "\u001b[m";
    }

    public String apply(String text) {
        return this.prefix + text + this.suffix;
    }

    public AnsiColor getForeground() {
        return this.foreground;
    }

    public AnsiColor getBackground() {
        return this.background;
    }

    public AnsiStyle getStyle() {
        return this.style;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.foreground).append((Object)this.background).append((Object)this.style).toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AnsiFormat)) {
            return false;
        }
        AnsiFormat that = (AnsiFormat)obj;
        return new EqualsBuilder().append((Object)this.foreground, (Object)that.foreground).append((Object)this.background, (Object)that.background).append((Object)this.style, (Object)that.style).isEquals();
    }
}

