/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.common.encryption;

import com.netapp.common.encryption.ByteArrayCipher;
import com.netapp.common.encryption.StreamCipher;
import com.netapp.common.encryption.StringCipher;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.commons.codec.binary.Base64;

public class DES
implements ByteArrayCipher,
StringCipher,
StreamCipher {
    private static final String CHAR_ENCODING = "UTF-8";
    private static final byte[] SALT = new byte[]{-2, -36, -70, -104, 118, 84, 50, 16};
    private static final int ITERATION_COUNT = 17;
    private final String algorithm;
    private final SecretKey key;
    private final AlgorithmParameterSpec params;
    private transient Cipher eCipher;
    private transient Cipher dCipher;

    public DES(String algorithm, SecretKey key, AlgorithmParameterSpec params) {
        this.algorithm = algorithm;
        this.key = key;
        this.params = params;
    }

    public DES(String password) {
        try {
            PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), SALT, 17);
            this.key = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(spec);
            this.algorithm = this.key.getAlgorithm();
            this.params = new PBEParameterSpec(SALT, 17);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] encrypt(byte[] input) {
        try {
            return this.getEncryptionCipher().doFinal(input);
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeException(e);
        }
        catch (BadPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] decrypt(byte[] input) {
        try {
            return this.getDecryptionCipher().doFinal(input);
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeException(e);
        }
        catch (BadPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String encrypt(String plaintext) {
        try {
            byte[] bytes = plaintext.getBytes(CHAR_ENCODING);
            bytes = this.encrypt(bytes);
            return new String(Base64.encodeBase64((byte[])bytes), CHAR_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String decrypt(String encrypted) {
        try {
            byte[] bytes = Base64.decodeBase64((byte[])encrypted.getBytes(CHAR_ENCODING));
            bytes = this.decrypt(bytes);
            return new String(bytes, CHAR_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public InputStream decrypt(InputStream encrypted) {
        BufferedInputStream stream = new BufferedInputStream(encrypted);
        return new CipherInputStream(stream, this.getDecryptionCipher());
    }

    @Override
    public OutputStream encrypt(OutputStream plaintext) {
        return new CipherOutputStream(plaintext, this.getEncryptionCipher());
    }

    private Cipher getEncryptionCipher() {
        if (this.eCipher == null) {
            this.eCipher = this.createCipher(1);
        }
        return this.eCipher;
    }

    private Cipher getDecryptionCipher() {
        if (this.dCipher == null) {
            this.dCipher = this.createCipher(2);
        }
        return this.dCipher;
    }

    private Cipher createCipher(int opmode) {
        try {
            Cipher cipher = Cipher.getInstance(this.algorithm);
            cipher.init(opmode, (Key)this.key, this.params);
            return cipher;
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException(e);
        }
    }

    public static StringCipher getApplicationCipher() {
        return new DES("JulQbVObgure");
    }

    public static DES getSnapdriveUnixCipher() {
        try {
            String cipherName = "DES";
            String cipherOptions = "/PCBC/NoPadding";
            IvParameterSpec params = new IvParameterSpec(SALT);
            SecretKey key = SecretKeyFactory.getInstance("DES").generateSecret(new DESKeySpec(new byte[]{-36, -3, -33, 117, -51, -82, -85, -118}));
            return new DES("DES/PCBC/NoPadding", key, params);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        if (args.length != 1) {
            System.err.println("Usage: DES <secret>");
            System.exit(1);
        }
        StringCipher des = DES.getApplicationCipher();
        String a = des.encrypt(args[0]);
        System.out.println("{des}" + a);
    }
}

