/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.common.graph;

import com.netapp.common.graph.Graph;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;

class DepthFirstPreorderIterator<T>
implements Iterator<T> {
    private Graph<T> graph;
    private Stack<T> nodesToVisit;
    private Set<T> nodesAlreadyVisited;

    DepthFirstPreorderIterator(T startNode, Graph<T> graph) {
        this.graph = graph;
        this.nodesToVisit = new Stack();
        this.nodesAlreadyVisited = new HashSet<T>();
        this.nodesToVisit.push(startNode);
    }

    @Override
    public boolean hasNext() {
        return !this.nodesToVisit.isEmpty();
    }

    @Override
    public T next() {
        T node = this.nodesToVisit.pop();
        this.nodesAlreadyVisited.add(node);
        for (T successor : this.graph.getSuccessors(node)) {
            if (this.nodesAlreadyVisited.contains(successor)) continue;
            this.nodesToVisit.push(successor);
        }
        return node;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

