/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.common.graph;

import com.google.common.base.Function;
import com.netapp.common.graph.BasicDisplayNodeFunction;
import com.netapp.common.graph.DisplayNode;
import com.netapp.common.graph.Graph;
import com.netapp.common.graph.GraphRepresentable;
import com.netapp.common.graph.GraphvizEncoder;
import java.io.StringWriter;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class DisplayGraph {
    private String name;
    private Graph<DisplayNode> graph;
    private DisplayNode entry;

    private DisplayGraph(String name, Graph<DisplayNode> graph) {
        this.name = name;
        this.graph = graph;
        this.entry = new DisplayNode(null, "ENTRY", null);
    }

    public DisplayGraph(String name) {
        this(name, new Graph<DisplayNode>());
    }

    public static DisplayGraph fromGraph(GraphRepresentable graphRepresentable) {
        return DisplayGraph.fromGraph(ClassUtils.getShortClassName(graphRepresentable.getClass()), graphRepresentable.getGraph());
    }

    public static DisplayGraph fromGraph(String name, Graph<?> graph) {
        return DisplayGraph.fromGraph(name, graph, BasicDisplayNodeFunction.INSTANCE);
    }

    public static <T> DisplayGraph fromGraph(String name, Graph<T> graph, Function<T, DisplayNode> function) {
        return new DisplayGraph(name, graph.apply(function));
    }

    public String getName() {
        return this.name;
    }

    public DisplayGraph withName(String name) {
        this.name = name;
        return this;
    }

    public Graph<DisplayNode> getGraph() {
        return this.graph;
    }

    public DisplayNode getEntry() {
        return this.entry;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.name).append(this.graph).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DisplayGraph) {
            if (this == obj) {
                return true;
            }
            DisplayGraph other = (DisplayGraph)obj;
            return new EqualsBuilder().append((Object)this.name, (Object)other.name).append(this.graph, other.graph).isEquals();
        }
        return false;
    }

    public String toGraphviz() {
        return this.toGraphviz(GraphvizEncoder.RankDir.TOP_TO_BOTTOM);
    }

    public String toGraphviz(GraphvizEncoder.RankDir rankDir) {
        StringWriter stringWriter = new StringWriter();
        new GraphvizEncoder(stringWriter).encode(this, rankDir);
        return stringWriter.toString();
    }
}

