/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.common.graph;

import com.google.common.collect.Maps;
import com.netapp.common.graph.DisplayGraph;
import com.netapp.common.graph.DisplayNode;
import com.netapp.common.graph.Graph;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;

public class GraphvizEncoder {
    private final PrintWriter out;

    public GraphvizEncoder(Writer writer) {
        this.out = new PrintWriter(writer);
    }

    public void encode(DisplayGraph graph) {
        this.encode(graph, RankDir.TOP_TO_BOTTOM);
    }

    public void encode(DisplayGraph graph, RankDir rankDir) {
        String openBrace = rankDir == RankDir.TOP_TO_BOTTOM || rankDir == RankDir.BOTTOM_TO_TOP ? "{" : "";
        String closeBrace = rankDir == RankDir.TOP_TO_BOTTOM || rankDir == RankDir.BOTTOM_TO_TOP ? "}" : "";
        this.out.println("digraph G {");
        this.out.println();
        this.out.println("compound=true");
        this.out.println("rankdir=" + rankDir.keyword);
        this.out.println("bgcolor=white; fontcolor=black; fontname=Helvetica; fontsize=10.0");
        this.out.printf("label=\"%s\"%n", graph.getName());
        this.out.println();
        this.out.println("edge [color=black, fontcolor=black, fontname=Helvetica, fontsize=10.0]");
        this.out.println();
        this.out.println("node [color=black, fontcolor=black, fontname=\"Helvetica-Bold\", fontsize=10.0, shape=record, style=\"solid,filled\"]");
        this.out.println();
        HashMap nodeNameMap = Maps.newHashMap();
        int nodeId = 0;
        for (DisplayNode displayNode : graph.getGraph().getNodes()) {
            String nodeName = "node_" + nodeId++;
            nodeNameMap.put(displayNode, nodeName);
            this.out.printf("%s [%n", nodeName);
            String contentString = this.getContentString(displayNode);
            this.out.printf("  label=\"%s%s%s\"%n", openBrace, contentString, closeBrace);
            this.out.printf("  fillcolor=%s%n", displayNode.getColor());
            this.out.println("]");
            this.out.println();
        }
        for (Graph.Edge edge : graph.getGraph().getEdges()) {
            String sourceNodeName = (String)nodeNameMap.get(edge.getSource());
            String destNodeName = (String)nodeNameMap.get(edge.getDest());
            this.out.printf("%s -> %s%n", sourceNodeName, destNodeName);
        }
        this.out.println("}");
        this.out.flush();
    }

    private String escapeSpecialCharacters(String input) {
        return input.replaceAll(" ", "\\ ").replaceAll("<", "\\\\<").replaceAll(">", "\\\\>");
    }

    private String getContentString(DisplayNode node) {
        StringBuilder builder = new StringBuilder();
        if (node.getTopContent() != null) {
            builder.append(this.escapeSpecialCharacters(node.getTopContent()));
        }
        if (node.getMiddleContent() != null) {
            if (node.getTopContent() != null) {
                builder.append("\\n|");
            }
            builder.append(this.escapeSpecialCharacters(node.getMiddleContent()));
        }
        if (node.getBottomContent() != null) {
            if (node.getTopContent() != null || node.getMiddleContent() != null) {
                builder.append("\\l|");
            }
            builder.append(this.escapeSpecialCharacters(node.getBottomContent()));
            builder.append("\\n");
        }
        return builder.toString();
    }

    public static enum RankDir {
        TOP_TO_BOTTOM("TB"),
        LEFT_TO_RIGHT("LR"),
        BOTTOM_TO_TOP("BT"),
        RIGHT_TO_LEFT("RL");

        private String keyword;

        private RankDir(String keyword) {
            this.keyword = keyword;
        }
    }
}

