/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.common.logging;

import com.netapp.common.logging.LogLevel;
import com.netapp.common.logging.MessageBundle;
import com.netapp.common.logging.MessageKey;
import com.netapp.common.logging.NALogger;
import com.netapp.common.util.StringUtils;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="logMessage", namespace="http://www.netapp.com/smai/Operation")
@XmlAccessorType(value=XmlAccessType.FIELD)
@SuppressWarnings(value={"Se"})
public class LogMessage
implements Serializable {
    private static final String BOOLEAN_REGEX = "(true|false)";
    private static final String INT_REGEX = "[\\-\\+]?\\d+";
    private static final String FLOAT_REGEX = "[\\-\\+]?\\d?\\.\\d+";
    private static final long serialVersionUID = 0L;
    @XmlElement
    protected Date timestamp;
    @XmlElement
    protected LogLevel level;
    @XmlElement
    protected String thread;
    @XmlElement
    protected String location;
    @XmlElement
    protected String msgKeyClass;
    @XmlElement
    protected String msgKeyValue;
    protected transient MessageKey msgKey;
    @XmlElementWrapper(name="parameters", nillable=true)
    @XmlElement(name="parameter")
    List<String> parameters;
    protected transient Object[] castParameters;
    @XmlElement
    protected String message;
    protected transient String localizedMessage;

    public LogMessage() {
        this.parameters = new ArrayList<String>();
    }

    public LogMessage(LogLevel level, String location, MessageKey msgKey, Object ... parameters) {
        this.timestamp = new Date();
        this.level = level;
        this.thread = Thread.currentThread().getName();
        this.location = location;
        this.msgKey = msgKey;
        this.msgKeyClass = msgKey.getClass().getName();
        this.msgKeyValue = msgKey.name();
        if (parameters != null && parameters.length > 0) {
            this.message = MessageBundle.localizeMessage(msgKey, parameters);
            this.parameters = new ArrayList<String>();
            for (int i = 0; i < parameters.length; ++i) {
                String parameter = parameters[i] == null ? "null" : parameters[i].toString();
                this.parameters.add(parameter);
            }
        } else {
            this.message = MessageBundle.localizeMessage(msgKey);
        }
        this.localizedMessage = this.message;
    }

    @SuppressWarnings(value={"EI2"})
    public void setTimestamp(Date timestamp) {
        assert (this.timestamp == null);
        this.timestamp = timestamp;
    }

    @SuppressWarnings(value={"EI"})
    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setLevel(LogLevel level) {
        assert (this.level == null);
        this.level = level;
    }

    public LogLevel getLevel() {
        return this.level;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public void setThread(String thread) {
        this.thread = thread;
    }

    public String getThread() {
        return this.thread;
    }

    public void setMessage(String message) {
        assert (this.message == null);
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public String localizedMessage() {
        if (this.localizedMessage == null) {
            this.localizedMessage = this.msgKey() != null ? (this.castParameters() != null ? MessageBundle.localizeMessage(this.msgKey(), this.castParameters()) : MessageBundle.localizeMessage(this.msgKey())) : this.message;
        }
        return this.localizedMessage;
    }

    public void setMsgKeyClass(String messageKeyClass) {
        assert (this.msgKeyClass == null);
        this.msgKeyClass = messageKeyClass;
    }

    public String getMsgKeyClass() {
        return this.msgKeyClass;
    }

    public void setMsgKeyValue(String msgKeyValue) {
        assert (this.msgKeyValue == null);
        this.msgKeyValue = msgKeyValue;
    }

    public String getMsgKeyValue() {
        return this.msgKeyValue;
    }

    public void setParameters(List<String> parameters) {
        this.parameters = parameters;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public void relog() {
        NALogger.getLogger(this.location).log(this);
    }

    public MessageKey msgKey() {
        if (this.msgKey == null && !StringUtils.isEmpty(this.msgKeyClass) && !StringUtils.isEmpty(this.msgKeyValue)) {
            try {
                Class<?> enumClass = Class.forName(this.msgKeyClass);
                if (enumClass.isEnum() && MessageKey.class.isAssignableFrom(enumClass)) {
                    this.msgKey = (MessageKey)((Object)Enum.valueOf(enumClass.asSubclass(Enum.class), this.msgKeyValue));
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return this.msgKey;
    }

    @SuppressWarnings(value={"EI"})
    public Object[] castParameters() {
        if (this.castParameters == null && this.parameters != null && this.parameters.size() > 0) {
            this.castParameters = new Object[this.parameters.size()];
            for (int i = 0; i < this.parameters.size(); ++i) {
                String parameter = this.parameters.get(i);
                this.castParameters[i] = Pattern.matches(BOOLEAN_REGEX, parameter) ? Boolean.valueOf(Boolean.parseBoolean(parameter)) : (Pattern.matches(INT_REGEX, parameter) ? Long.valueOf(Long.parseLong(parameter)) : (Pattern.matches(FLOAT_REGEX, parameter) ? Double.valueOf(Double.parseDouble(parameter)) : parameter));
            }
        }
        return this.castParameters;
    }

    public String toString() {
        return this.message;
    }
}

