/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.common.logging;

import com.netapp.common.logging.JdkLoggerAdapterFactory;
import com.netapp.common.logging.LogAdapter;
import com.netapp.common.logging.LogAdapterFactory;
import com.netapp.common.logging.LogLevel;
import com.netapp.common.logging.LogListener;
import com.netapp.common.logging.LogMessage;
import com.netapp.common.logging.MessageKey;
import com.netapp.common.logging.SLF4JAdapterFactory;
import com.netapp.common.util.ListenerProxy;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@SuppressWarnings(value={"LI"})
public class NALogger {
    private static final Map<String, NALogger> loggers = new ConcurrentHashMap<String, NALogger>();
    private static LogAdapterFactory factory;
    private LogAdapter adapter;
    private String name;

    private NALogger(String name) {
        this.name = name;
        this.adapter = factory.createLogAdapter(name);
    }

    public static NALogger getLogger(Class<?> clazz) {
        return NALogger.getLogger(clazz.getName());
    }

    public static NALogger getLogger(String name) {
        NALogger logger = loggers.get(name);
        if (logger == null) {
            logger = new NALogger(name);
            loggers.put(name, logger);
        }
        return logger;
    }

    public static NALogger getLogger() {
        Throwable t = new Throwable();
        String caller = t.getStackTrace()[1].getClassName();
        return NALogger.getLogger(caller);
    }

    public static void addListener(LogListener listener) {
        ListenersHolder.LISTENERS.addListener(listener);
    }

    protected static void notifyListeners(LogMessage message) {
        ((LogListener)ListenersHolder.LISTENERS.proxy()).append(message);
    }

    public String debug(String msg) {
        return this.internal(msg);
    }

    public String debug(String msg, Object ... params) {
        return this.internal(msg, params);
    }

    public String debug(String msg, Throwable t, Object ... params) {
        return this.internal(msg, t, params);
    }

    public String internal(String msg) {
        this.adapter.log(LogLevel.DEBUG, msg);
        return msg;
    }

    public String internal(String msg, Object ... params) {
        String formattedMsg = String.format(msg, params);
        this.adapter.log(LogLevel.DEBUG, formattedMsg);
        return formattedMsg;
    }

    public String internal(String msg, Throwable t, Object ... params) {
        String formattedMsg = String.format(msg, params);
        this.adapter.log(LogLevel.DEBUG, formattedMsg, t);
        return formattedMsg;
    }

    public String internalTrace(String msg) {
        this.adapter.log(LogLevel.TRACE, msg);
        return msg;
    }

    public String internalTrace(String msg, Object ... params) {
        String formattedMsg = String.format(msg, params);
        this.adapter.log(LogLevel.TRACE, formattedMsg);
        return formattedMsg;
    }

    public String internalTrace(String msg, Throwable t, Object ... params) {
        String formattedMsg = String.format(msg, params);
        this.adapter.log(LogLevel.TRACE, formattedMsg, t);
        return formattedMsg;
    }

    String log(LogMessage msg) {
        this.adapter.log(msg);
        NALogger.notifyListeners(msg);
        return msg.localizedMessage();
    }

    String log(LogMessage msg, Throwable t) {
        this.adapter.log(msg, t);
        NALogger.notifyListeners(msg);
        return msg.localizedMessage();
    }

    public String log(LogLevel level, MessageKey key) {
        LogMessage msg = new LogMessage(level, this.name, key, null);
        return this.log(msg);
    }

    public String log(LogLevel level, MessageKey key, Throwable t) {
        LogMessage msg = new LogMessage(level, this.name, key, null);
        return this.log(msg, t);
    }

    public String log(LogLevel level, MessageKey key, Object ... params) {
        LogMessage msg = new LogMessage(level, this.name, key, params);
        return this.log(msg);
    }

    public String log(LogLevel level, MessageKey key, Throwable t, Object ... params) {
        LogMessage msg = new LogMessage(level, this.name, key, params);
        return this.log(msg, t);
    }

    public String trace(MessageKey key) {
        return this.log(LogLevel.TRACE, key);
    }

    public String trace(MessageKey key, Throwable t) {
        return this.log(LogLevel.TRACE, key, t);
    }

    public String trace(MessageKey key, Throwable t, Object ... params) {
        return this.log(LogLevel.TRACE, key, t, params);
    }

    public String trace(MessageKey key, Object ... params) {
        return this.log(LogLevel.TRACE, key, params);
    }

    public String debug(MessageKey key) {
        return this.log(LogLevel.DEBUG, key);
    }

    public String debug(MessageKey key, Throwable t) {
        return this.log(LogLevel.DEBUG, key, t);
    }

    public String debug(MessageKey key, Throwable t, Object ... params) {
        return this.log(LogLevel.DEBUG, key, t, params);
    }

    public String debug(MessageKey key, Object ... params) {
        return this.log(LogLevel.DEBUG, key, params);
    }

    public String info(MessageKey key) {
        return this.log(LogLevel.INFO, key);
    }

    public String info(MessageKey key, Throwable t) {
        return this.log(LogLevel.INFO, key, t);
    }

    public String info(MessageKey key, Throwable t, Object ... params) {
        return this.log(LogLevel.INFO, key, t, params);
    }

    public String info(MessageKey key, Object ... params) {
        return this.log(LogLevel.INFO, key, params);
    }

    public String warn(MessageKey key) {
        return this.log(LogLevel.WARN, key);
    }

    public String warn(MessageKey key, Throwable t) {
        return this.log(LogLevel.WARN, key, t);
    }

    public String warn(MessageKey key, Throwable t, Object ... params) {
        return this.log(LogLevel.WARN, key, t, params);
    }

    public String warn(MessageKey key, Object ... params) {
        return this.log(LogLevel.WARN, key, params);
    }

    public String error(MessageKey key) {
        return this.log(LogLevel.ERROR, key);
    }

    public String error(MessageKey key, Throwable t) {
        return this.log(LogLevel.ERROR, key, t);
    }

    public String error(MessageKey key, Throwable t, Object ... params) {
        return this.log(LogLevel.ERROR, key, t, params);
    }

    public String error(MessageKey key, Object ... params) {
        return this.log(LogLevel.ERROR, key, params);
    }

    public String log(String level, MessageKey key) {
        return this.log(LogLevel.parseLevel(level), key);
    }

    public String log(String level, MessageKey key, Throwable t) {
        return this.log(LogLevel.parseLevel(level), key, t);
    }

    public String log(String level, MessageKey key, Object ... params) {
        return this.log(LogLevel.parseLevel(level), key, params);
    }

    public String log(String level, MessageKey key, Throwable t, Object ... params) {
        return this.log(LogLevel.parseLevel(level), key, t, params);
    }

    public boolean isLogLevelEnabled(LogLevel level) {
        return this.adapter.isLogLevelEnabled(level);
    }

    static {
        try {
            factory = new SLF4JAdapterFactory();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (factory == null) {
            factory = new JdkLoggerAdapterFactory();
        }
    }

    private static class ListenersHolder {
        private static final ListenerProxy<LogListener> LISTENERS = new ListenerProxy<LogListener>(LogListener.class);

        private ListenersHolder() {
        }
    }
}

