/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.common.logging;

import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.netapp.common.ansi.AnsiColor;
import com.netapp.common.ansi.AnsiFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class NDC {
    private static final ThreadLocal<Deque<NDCElement>> STACKS = new ThreadLocal<Deque<NDCElement>>(){

        @Override
        protected Deque<NDCElement> initialValue() {
            return new ArrayDeque<NDCElement>();
        }
    };

    private NDC() {
    }

    public static void push(String s) {
        Deque<NDCElement> stack = STACKS.get();
        stack.push(new NDCElement(stack, s));
    }

    public static void push(String ... strings) {
        for (String s : strings) {
            NDC.push(s);
        }
    }

    public static String pop() {
        try {
            return STACKS.get().pop().getText();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public static void pop(int n) {
        Deque<NDCElement> stack = STACKS.get();
        try {
            for (int i = 0; i < n; ++i) {
                stack.pop();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public static void clear() {
        STACKS.get().clear();
    }

    public static String[] getElements() {
        ArrayList result = Lists.newArrayList();
        Iterator<NDCElement> i = NDC.get().descendingIterator();
        while (i.hasNext()) {
            result.add(i.next().text);
        }
        return result.toArray(new String[result.size()]);
    }

    static Deque<NDCElement> get() {
        return STACKS.get();
    }

    private static class ColorPicker {
        private static final Set<AnsiColor> COLORS = EnumSet.of(AnsiColor.RED, new AnsiColor[]{AnsiColor.GREEN, AnsiColor.YELLOW, AnsiColor.BLUE, AnsiColor.MAGENTA, AnsiColor.CYAN});
        private static final AtomicInteger ROOT_COUNTER = new AtomicInteger();
        private static final LoadingCache<List<NDCElement>, AtomicInteger> CHILD_COUNTS = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).maximumSize(500L).build((CacheLoader)new CacheLoader<List<NDCElement>, AtomicInteger>(){

            public AtomicInteger load(List<NDCElement> input) {
                return new AtomicInteger();
            }
        });
        private static final LoadingCache<NDCPath, AnsiColor> CACHE = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).maximumSize(500L).build((CacheLoader)new CacheLoader<NDCPath, AnsiColor>(){

            public AnsiColor load(NDCPath key) {
                Set colors = EnumSet.copyOf(COLORS);
                colors.removeAll(Collections2.transform((Collection)key.parents, (Function)NDCElement.COLOR_SELECTOR));
                if (colors.isEmpty()) {
                    colors = COLORS;
                }
                AtomicInteger counter = key.parents.isEmpty() ? ROOT_COUNTER : (AtomicInteger)CHILD_COUNTS.getUnchecked((Object)key.parents);
                int colorIndex = counter.getAndIncrement() % colors.size();
                return (AnsiColor)((Object)Iterables.get(colors, (int)colorIndex));
            }
        });

        private ColorPicker() {
        }

        static AnsiColor pickColor(Deque<NDCElement> parents, String text) {
            return (AnsiColor)((Object)CACHE.getUnchecked((Object)new NDCPath(parents, text)));
        }

        private static class NDCPath {
            private List<NDCElement> parents;
            private String text;

            NDCPath(Deque<NDCElement> parents, String text) {
                this.parents = ImmutableList.copyOf(parents);
                this.text = text;
            }

            public int hashCode() {
                return new HashCodeBuilder().append(this.parents).append((Object)this.text).toHashCode();
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof NDCPath)) {
                    return false;
                }
                NDCPath that = (NDCPath)obj;
                return new EqualsBuilder().append(this.parents, that.parents).append((Object)this.text, (Object)that.text).isEquals();
            }
        }
    }

    static class NDCElement {
        private static final Function<NDCElement, AnsiColor> COLOR_SELECTOR = new Function<NDCElement, AnsiColor>(){

            public AnsiColor apply(NDCElement input) {
                return input.getColor();
            }
        };
        private final AnsiFormat format;
        private final String text;

        NDCElement(Deque<NDCElement> parents, String text) {
            this.text = text;
            this.format = new AnsiFormat(ColorPicker.pickColor(parents, text), null, null);
        }

        String getText() {
            return this.text;
        }

        String getColoredText() {
            return this.format.apply(this.text);
        }

        AnsiColor getColor() {
            return this.format.getForeground();
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.format).append((Object)this.text).toHashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof NDCElement)) {
                return false;
            }
            NDCElement that = (NDCElement)obj;
            return new EqualsBuilder().append((Object)this.format, (Object)that.format).append((Object)this.text, (Object)that.text).isEquals();
        }

        public String toString() {
            return this.text;
        }
    }
}

