/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.common.logging;

import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import com.netapp.common.logging.NDC;
import java.util.Deque;
import java.util.Iterator;

public class NDCConverter
extends ClassicConverter {
    private static final String COLOR_PARAM = "color";
    private static final String COLOR_PROPERTY = "ndc.color";
    private volatile boolean colorEnabled;
    private volatile String separator;

    public void start() {
        this.separator = this.getFirstOption() == null ? "|" : this.getFirstOption();
        this.colorEnabled = Boolean.parseBoolean(this.getContext().getProperty(COLOR_PROPERTY)) && this.getOptionList().size() > 1 && COLOR_PARAM.equalsIgnoreCase((String)this.getOptionList().get(1));
        super.start();
    }

    public String convert(ILoggingEvent event) {
        Deque<NDC.NDCElement> stack = NDC.get();
        if (stack.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<NDC.NDCElement> i = stack.descendingIterator();
        while (i.hasNext()) {
            NDC.NDCElement next = i.next();
            sb.append(this.colorEnabled ? next.getColoredText() : next.getText());
            if (!i.hasNext()) continue;
            sb.append(this.separator);
        }
        String ndc = sb.toString();
        return ndc.equals("") ? "" : String.format(" [%s]", ndc);
    }
}

