/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.common.signal;

import com.netapp.common.MsgKey;
import com.netapp.common.logging.MessageKey;
import com.netapp.common.logging.NALogger;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class SignalHandlerImpl
implements SignalHandler {
    protected SignalHandler oldHandler;
    protected boolean isFatal;
    protected String signalName;
    protected ProgramType programType;
    private static final NALogger logger = NALogger.getLogger(SignalHandlerImpl.class);

    public SignalHandlerImpl(String signalName, boolean isFatal, ProgramType programType) {
        this.isFatal = isFatal;
        this.programType = programType;
        this.signalName = signalName;
    }

    public void replace() {
        this.replace(false);
    }

    public void replace(boolean chain) {
        logger.internal("Replacing signal handler for 'SIG" + this.signalName + "'");
        try {
            SignalHandler last = Signal.handle(new Signal(this.signalName), this);
            this.oldHandler = chain ? last : null;
        }
        catch (Throwable t) {
            logger.internal("Error replacing 'SIG" + this.signalName + "': " + t.getLocalizedMessage());
        }
    }

    @Override
    @SuppressWarnings(value={"Dm"})
    public void handle(Signal sig) {
        if (this.isFatal) {
            logger.error((MessageKey)MsgKey.SIGNAL_FATAL_SIGNAL, sig);
        } else {
            logger.warn((MessageKey)MsgKey.SIGNAL_NONFATAL_SIGNAL, sig);
        }
        try {
            if (this.oldHandler != null && this.oldHandler != SIG_DFL && this.oldHandler != SIG_IGN) {
                logger.internal("Calling original handler for signal " + sig);
                this.oldHandler.handle(sig);
            }
        }
        catch (Throwable t) {
            logger.internal("Original signal handler failed, reason " + t);
        }
        logger.internal("Handler for signal " + sig + " finished.");
        if (this.isFatal) {
            System.exit(1);
        }
    }

    public static enum ProgramType {
        SERVER,
        GUI,
        CLI;

    }
}

