/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.common.text;

import com.netapp.common.MsgKey;
import com.netapp.common.logging.MessageBundle;
import com.netapp.common.text.SubstitutionPatternContext;
import com.netapp.common.text.SubstitutionPatternSyntaxException;
import com.netapp.common.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class SubstitutionPattern {
    private final List<SubstitutionPatternElement> elements;

    private SubstitutionPattern(List<SubstitutionPatternElement> elements) {
        this.elements = Collections.unmodifiableList(elements);
    }

    public String render(SubstitutionPatternContext context) {
        StringBuilder builder = new StringBuilder();
        for (SubstitutionPatternElement element : this.elements) {
            builder.append(element.getValue(context));
        }
        return builder.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (SubstitutionPatternElement element : this.elements) {
            builder.append(element.toString());
        }
        return builder.toString();
    }

    public List<SubstitutionPatternElement> getElements() {
        return this.elements;
    }

    public Set<String> getVariableNames() {
        HashSet<String> variableNames = new HashSet<String>();
        for (SubstitutionPatternElement element : this.elements) {
            if (!(element instanceof VariableElement)) continue;
            variableNames.add(((VariableElement)element).getName());
        }
        return variableNames;
    }

    public static SubstitutionPattern compile(String patternString, Set<String> validVariableNames, Set<String> requiredVaribleNames) {
        return SubstitutionPattern.compile(patternString, validVariableNames, requiredVaribleNames, SubstitutionPattern.getDefaultVariableStartToken(), SubstitutionPattern.getDefaultVariableEndToken());
    }

    public static SubstitutionPattern compile(String patternString, Set<String> validVariableNames, Set<String> requiredVaribleNames, String variableStartToken, String variableEndToken) {
        ArrayList<SubstitutionPatternElement> elements = new ArrayList<SubstitutionPatternElement>();
        int start = 0;
        int variableStartIndex = 0;
        while (start < patternString.length() && (variableStartIndex = patternString.indexOf(variableStartToken, start)) != -1) {
            int variableEndIndex = patternString.indexOf(variableEndToken, variableStartIndex);
            if (variableEndIndex != -1) {
                if (variableStartIndex != start) {
                    elements.add(new TextElement(patternString.substring(start, variableStartIndex)));
                }
                String variableName = patternString.substring(variableStartIndex + variableStartToken.length(), variableEndIndex);
                elements.add(new VariableElement(variableName, variableStartToken, variableEndToken));
                start = variableEndIndex + 1;
                continue;
            }
            elements.add(new TextElement(patternString.substring(start)));
            start = patternString.length();
        }
        if (start < patternString.length()) {
            elements.add(new TextElement(patternString.substring(start)));
        }
        return SubstitutionPattern.compile(elements, validVariableNames, requiredVaribleNames);
    }

    public static SubstitutionPattern compile(List<SubstitutionPatternElement> elements, Set<String> validVariableNames, Set<String> requiredVaribleNames) {
        HashSet requiredVaribleNamesRemaining = requiredVaribleNames == null ? new HashSet() : new HashSet<String>(requiredVaribleNames);
        HashSet<String> invalidVaribleNames = new HashSet<String>();
        StringBuilder patternString = new StringBuilder();
        for (SubstitutionPatternElement element : elements) {
            if (element instanceof VariableElement) {
                VariableElement variableElement = (VariableElement)element;
                if (validVariableNames != null && !validVariableNames.contains(variableElement.getName())) {
                    invalidVaribleNames.add(variableElement.getName());
                }
                requiredVaribleNamesRemaining.remove(variableElement.getName());
            }
            patternString.append(element.toString());
        }
        if (!requiredVaribleNamesRemaining.isEmpty()) {
            throw new SubstitutionPatternSyntaxException(MessageBundle.localizeMessage(MsgKey.SUBSTITUTION_PATTERN_REQUIRED_VARIABLES_NOT_FOUND, CollectionUtils.collectionToString(requiredVaribleNamesRemaining, ", ", "{", "}"), CollectionUtils.collectionToString(requiredVaribleNamesRemaining, "_", "{", "}"), patternString), true, false);
        }
        if (!invalidVaribleNames.isEmpty()) {
            throw new SubstitutionPatternSyntaxException(MessageBundle.localizeMessage(MsgKey.SUBSTITUTION_PATTERN_INVALID_VARIABLES, CollectionUtils.collectionToString(invalidVaribleNames, ", "), patternString), false, true);
        }
        return new SubstitutionPattern(elements);
    }

    public static String getDefaultVariableStartToken() {
        return MessageBundle.localizeMessage(MsgKey.SUBSTITUTION_PATTERN_VARIABLE_START_TOKEN);
    }

    public static String getDefaultVariableEndToken() {
        return MessageBundle.localizeMessage(MsgKey.SUBSTITUTION_PATTERN_VARIABLE_END_TOKEN);
    }

    public static final class VariableElement
    implements SubstitutionPatternElement {
        private String name;
        private final String variableStartToken;
        private final String variableEndToken;

        public VariableElement(String name) {
            this(name, SubstitutionPattern.getDefaultVariableStartToken(), SubstitutionPattern.getDefaultVariableEndToken());
        }

        public VariableElement(String name, String variableStartToken, String variableEndToken) {
            this.name = name;
            this.variableStartToken = variableStartToken;
            this.variableEndToken = variableEndToken;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String getValue(SubstitutionPatternContext context) {
            return context.getValue(this.name);
        }

        public String toString() {
            return this.variableStartToken + this.name + this.variableEndToken;
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this);
        }
    }

    public static final class TextElement
    implements SubstitutionPatternElement {
        private String text;

        public TextElement(String text) {
            this.text = text;
        }

        @Override
        public String getValue(SubstitutionPatternContext context) {
            return this.text;
        }

        public String toString() {
            return this.text;
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this);
        }
    }

    public static interface SubstitutionPatternElement {
        public String getValue(SubstitutionPatternContext var1);
    }
}

