/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.common.util;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.netapp.common.util.JavaTypeParser;
import com.netapp.common.util.ParameterizedTypeImpl;
import com.netapp.common.util.ParseException;
import com.netapp.common.util.StringUtils;
import java.io.File;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ClassUtils {
    private static final Pattern BEAN_METHOD_REGEX = Pattern.compile("(set|get|is)([A-Z].*)");
    private static final Set<String> RESERVED_WORDS = new TreeSet<String>();

    private ClassUtils() {
        throw new RuntimeException("ClassUtils may not be instantiated");
    }

    public static boolean isJavaReservedWord(String word) {
        return RESERVED_WORDS.contains(word);
    }

    public static String classNameToFilePath(String clazz) {
        return clazz.replace('.', File.separatorChar);
    }

    public static String extractPackageName(String clazz) {
        int last = clazz.lastIndexOf(".");
        if (last >= 0) {
            return clazz.substring(0, last);
        }
        return null;
    }

    public static String extractUnqualifiedClassName(String clazz) {
        int last = clazz.lastIndexOf(".");
        if (last >= 0) {
            return clazz.substring(last + 1);
        }
        return clazz;
    }

    public static String unqualifiedClassNameForObject(Object o) {
        String className = o.getClass().getName();
        return ClassUtils.extractUnqualifiedClassName(className);
    }

    public static boolean isBeanMethod(Method method) {
        Matcher matcher = BEAN_METHOD_REGEX.matcher(method.getName());
        if (matcher.matches()) {
            if ("set".equals(matcher.group(1)) && method.getParameterTypes().length == 1) {
                return true;
            }
            if (method.getParameterTypes().length == 0) {
                return true;
            }
        }
        return false;
    }

    public static List<Method> findSetterMethod(Class<?> clazz, String fieldName) {
        ArrayList<Method> methods = new ArrayList<Method>();
        String methodName = "set" + StringUtils.initialUpperCase(fieldName);
        for (Method m : clazz.getMethods()) {
            if (!m.getName().equals(methodName) || m.getGenericParameterTypes().length != 1) continue;
            methods.add(m);
        }
        return methods;
    }

    public static Method findSetterMethod(Class<?> clazz, String fieldName, Type parameterType) {
        String methodName = "set" + StringUtils.initialUpperCase(fieldName);
        for (Method m : clazz.getMethods()) {
            Type[] genericParameterTypes = m.getGenericParameterTypes();
            if (!m.getName().equals(methodName) || genericParameterTypes.length != 1 || !genericParameterTypes[0].equals(parameterType)) continue;
            return m;
        }
        return null;
    }

    public static Method findGetterMethod(Class<?> clazz, String fieldName) {
        String getMethodName = "get" + StringUtils.initialUpperCase(fieldName);
        String isMethodName = "is" + StringUtils.initialUpperCase(fieldName);
        for (Method m : clazz.getMethods()) {
            if (!m.getName().equals(isMethodName) && !m.getName().equals(getMethodName) || m.getGenericParameterTypes().length != 0) continue;
            return m;
        }
        return null;
    }

    public static String extractFieldNameFromBeanMethod(Method method) {
        if (!ClassUtils.isBeanMethod(method)) {
            throw new IllegalArgumentException("Method " + method.getName() + " is not a JavaBean method");
        }
        Matcher m = BEAN_METHOD_REGEX.matcher(method.getName());
        m.matches();
        return StringUtils.initialLowerCase(m.group(2));
    }

    public static Type extractFieldTypeFromBeanMethod(Method method) {
        if (!ClassUtils.isBeanMethod(method)) {
            throw new IllegalArgumentException("Method " + method.getName() + " is not a JavaBean method");
        }
        if (method.getName().startsWith("set")) {
            return method.getGenericParameterTypes()[0];
        }
        return method.getGenericReturnType();
    }

    public static boolean isGenericCollection(Type t) {
        ParameterizedType pt;
        if (t instanceof ParameterizedType && (pt = (ParameterizedType)t).getRawType() instanceof Class) {
            Class rawType = (Class)pt.getRawType();
            return Collection.class.isAssignableFrom(rawType);
        }
        return false;
    }

    public static Class<?> extractImmediateClass(Type t) {
        Class<?> clazz = null;
        if (t instanceof Class) {
            clazz = (Class<?>)t;
        } else if (ClassUtils.isGenericCollection(t)) {
            clazz = ClassUtils.extractCollectionClass(t);
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Type " + t + " is not supported");
        }
        return clazz;
    }

    public static Class<?> extractObjectClass(Type t) {
        ParameterizedType pt;
        Type parameterType;
        Class clazz = null;
        if (t instanceof Class) {
            clazz = (Class)t;
        } else if (ClassUtils.isGenericCollection(t) && (parameterType = (pt = (ParameterizedType)t).getActualTypeArguments()[0]) instanceof Class) {
            clazz = (Class)parameterType;
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Type " + t + " is not supported");
        }
        return clazz;
    }

    public static Class<?> extractCollectionClass(Type t) {
        Class clazz = null;
        if (ClassUtils.isGenericCollection(t)) {
            ParameterizedType pt = (ParameterizedType)t;
            Type ct = pt.getRawType();
            clazz = (Class)ct;
        }
        return clazz;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> T createObject(Class<T> clazz, String content) {
        void var3_7;
        if (content == null) {
            return null;
        }
        if (!clazz.isPrimitive() && (Modifier.isInterface(clazz.getModifiers()) || Modifier.isAbstract(clazz.getModifiers()))) {
            throw new IllegalArgumentException(clazz.getName() + " may not be directly instantiated");
        }
        Object result = null;
        Object var3_3 = null;
        try {
            if (clazz.equals(String.class)) {
                result = content;
            } else if (clazz.isEnum()) {
                result = Enum.valueOf(clazz.asSubclass(Enum.class), content.trim());
            } else if (clazz.equals(Byte.class) || clazz.equals(Byte.TYPE)) {
                clazz = Byte.class;
                result = Byte.parseByte(content.trim());
            } else if (clazz.equals(Short.class) || clazz.equals(Short.TYPE)) {
                clazz = Short.class;
                result = Short.parseShort(content.trim());
            } else if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
                clazz = Integer.class;
                result = Integer.parseInt(content.trim());
            } else if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
                clazz = Long.class;
                result = Long.parseLong(content.trim());
            } else if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
                clazz = Boolean.class;
                if ("true".equalsIgnoreCase(content = content.trim())) {
                    result = Boolean.TRUE;
                } else {
                    if (!"false".equalsIgnoreCase(content)) throw new IllegalArgumentException("Invalid boolean value " + content + "; must be TRUE or FALSE");
                    result = Boolean.FALSE;
                }
            } else if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
                clazz = Float.class;
                result = Float.valueOf(Float.parseFloat(content.trim()));
            } else if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
                clazz = Double.class;
                result = Double.parseDouble(content.trim());
            } else if (clazz.equals(Date.class)) {
                long l = Long.parseLong(content.trim()) * 1000L;
                result = new Date(l);
            } else {
                Constructor<Object> con = clazz.getConstructor(String.class);
                result = con.newInstance(content);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Number format exception while converting " + content + " to " + clazz.getSimpleName(), e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No suitable constructor for " + clazz.getName() + "found", e);
        }
        catch (InstantiationException e) {
            InstantiationException instantiationException = e;
        }
        catch (IllegalAccessException e) {
            IllegalAccessException illegalAccessException = e;
        }
        catch (InvocationTargetException e) {
            InvocationTargetException invocationTargetException = e;
        }
        if (var3_7 == null) return (T)clazz.cast(result);
        throw new IllegalArgumentException("Reflection exception while instantiating " + clazz.getName() + "(" + content + ")", (Throwable)var3_7);
    }

    public static <T> T createObject(Class<T> clazz) {
        try {
            Constructor<T> defaultConstructor = clazz.getDeclaredConstructor(new Class[0]);
            defaultConstructor.setAccessible(true);
            return defaultConstructor.newInstance(new Object[0]);
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T createCollection(Class<T> clazz, String content) {
        if (clazz.isPrimitive()) {
            return ClassUtils.createObject(clazz, content);
        }
        Collection result = null;
        ReflectiveOperationException t = null;
        try {
            if (ClassUtils.typeAssignableFrom(List.class, clazz)) {
                result = clazz.isInterface() ? new ArrayList() : (Collection)clazz.newInstance();
            } else if (ClassUtils.typeAssignableFrom(Set.class, clazz)) {
                result = clazz.isInterface() ? new HashSet() : (Collection)clazz.newInstance();
            } else if (ClassUtils.typeAssignableFrom(Queue.class, clazz)) {
                result = clazz.isInterface() ? new LinkedList() : (Collection)clazz.newInstance();
            } else {
                throw new IllegalArgumentException("Unsupported collection type " + clazz.getName());
            }
            if (null != content) {
                result.add(content);
            }
        }
        catch (InstantiationException e) {
            t = e;
        }
        catch (IllegalAccessException e) {
            t = e;
        }
        if (t != null) {
            throw new IllegalArgumentException("Reflection exception while instantiating " + clazz.getName() + "(" + content + ")", t);
        }
        return clazz.cast(result);
    }

    public static void setBeanProperty(Object bean, String property, String value) {
        List<Method> setters = ClassUtils.findSetterMethod(bean.getClass(), property);
        if (setters.size() != 1) {
            throw new IllegalArgumentException("No property " + property + " on " + bean.getClass().getName());
        }
        try {
            Method m = setters.get(0);
            Object o = ClassUtils.createObject(m.getParameterTypes()[0], value);
            m.invoke(bean, o);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static boolean typeAssignableFrom(Type target, Type source) {
        if (target.equals(Object.class)) {
            return true;
        }
        if (target.equals(source)) {
            return true;
        }
        if (target instanceof Class && source instanceof Class && ((Class)target).isAssignableFrom((Class)source)) {
            return true;
        }
        if ((target.equals(Byte.class) || target.equals(Byte.TYPE)) && (source.equals(Byte.class) || source.equals(Byte.TYPE))) {
            return true;
        }
        if ((target.equals(Short.class) || target.equals(Short.TYPE)) && (source.equals(Short.class) || source.equals(Short.TYPE))) {
            return true;
        }
        if ((target.equals(Integer.class) || target.equals(Integer.TYPE)) && (source.equals(Integer.class) || source.equals(Integer.TYPE))) {
            return true;
        }
        if ((target.equals(Long.class) || target.equals(Long.TYPE)) && (source.equals(Long.class) || source.equals(Long.TYPE))) {
            return true;
        }
        if ((target.equals(Boolean.class) || target.equals(Boolean.TYPE)) && (source.equals(Boolean.class) || source.equals(Boolean.TYPE))) {
            return true;
        }
        if ((target.equals(Float.class) || target.equals(Float.TYPE)) && (source.equals(Float.class) || source.equals(Float.TYPE))) {
            return true;
        }
        return !(!target.equals(Double.class) && !target.equals(Double.TYPE) || !source.equals(Double.class) && !source.equals(Double.TYPE));
    }

    public static boolean typeAssignableFromCollection(Type source) {
        if (ClassUtils.typeAssignableFrom(List.class, source) || ClassUtils.typeAssignableFrom(Set.class, source) || ClassUtils.typeAssignableFrom(Queue.class, source)) {
            return true;
        }
        return ClassUtils.typeAssignableFrom(List.class, source.getClass()) || ClassUtils.typeAssignableFrom(Set.class, source.getClass()) || ClassUtils.typeAssignableFrom(Queue.class, source.getClass());
    }

    public static Class<?>[] extractClasses(Object ... objects) {
        Class[] classes = new Class[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            classes[i] = objects[i].getClass();
        }
        return classes;
    }

    public static Type parseTypeDeclaration(String declaration) throws ClassNotFoundException {
        JavaTypeParser parser = new JavaTypeParser(new StringReader(declaration));
        try {
            Type type = parser.Type();
            if (type instanceof ParameterizedTypeImpl) {
                ClassUtils.validateTypeParameters((ParameterizedTypeImpl)type);
            }
            return type;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private static void validateTypeParameters(ParameterizedTypeImpl type) {
        if (!(type.getRawType() instanceof Class)) {
            throw new IllegalArgumentException("Parameterized type " + type.getRawType() + " is not a parameterized type.");
        }
        Class clazz = (Class)type.getRawType();
        if (type.getActualTypeArguments().length != clazz.getTypeParameters().length) {
            throw new IllegalArgumentException("Invalid number of type arguments for " + clazz.getName());
        }
        for (Type typeArgument : type.getActualTypeArguments()) {
            if (!(typeArgument instanceof ParameterizedTypeImpl)) continue;
            ClassUtils.validateTypeParameters((ParameterizedTypeImpl)typeArgument);
        }
    }

    static Class<?> resolveClass(String name) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (clazz == null && !name.contains(".")) {
            try {
                clazz = Class.forName("java.lang." + name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        return clazz;
    }

    public static List<Field> getFieldsAnnotatedBy(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        LinkedList fieldList = Lists.newLinkedList();
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(annotationClass)) continue;
            fieldList.add(field);
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            fieldList.addAll(ClassUtils.getFieldsAnnotatedBy(superClass, annotationClass));
        }
        return fieldList;
    }

    public static List<Method> getMethodsAnnotatedBy(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        LinkedList methodList = Lists.newLinkedList();
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(annotationClass)) continue;
            methodList.add(method);
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            methodList.addAll(ClassUtils.getMethodsAnnotatedBy(superClass, annotationClass));
        }
        return methodList;
    }

    public static <S, T> Function<S, T> createFunctionForBeanProperty(final String beanPropertyName) {
        return new Function<S, T>(){

            public T apply(S from) {
                Method getter = ClassUtils.findGetterMethod(from.getClass(), beanPropertyName);
                assert (getter != null);
                try {
                    return getter.invoke(from, new Object[0]);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    static {
        RESERVED_WORDS.addAll(Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "true", "false", "null"));
    }
}

