/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.common.util;

import com.netapp.common.MsgKey;
import com.netapp.common.logging.MessageBundle;
import com.netapp.common.logging.MessageKey;
import com.netapp.common.logging.NALogger;
import com.netapp.common.util.ClassUtils;
import com.netapp.common.util.ConfigBundle;
import com.netapp.common.util.FileProperty;
import com.netapp.common.util.Interval;
import java.io.File;
import java.util.Properties;

public class ConfigProperty<T> {
    private static final NALogger logger = NALogger.getLogger(ConfigProperty.class);
    protected final String property;
    protected final Class<T> type;
    protected final T defaultValue;
    protected boolean isRequired;

    public ConfigProperty(Class<T> type, String property) {
        this(type, property, null);
    }

    public ConfigProperty(Class<T> type, String property, T defaultValue) {
        this.type = type;
        this.property = property;
        this.defaultValue = defaultValue;
    }

    public String getProperty() {
        return this.property;
    }

    public Class<T> getType() {
        return this.type;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public ConfigProperty<T> required() {
        if (this.defaultValue != null) {
            throw new IllegalStateException("Cannot mark a ConfigProperty with a default value as required");
        }
        this.isRequired = true;
        return this;
    }

    public T lookup(ConfigBundle bundle) {
        return this.lookup(bundle.getProperties());
    }

    public T lookup(Properties properties) {
        T value = this.defaultValue;
        String propValue = properties.getProperty(this.property);
        if (propValue != null) {
            try {
                value = ClassUtils.createObject(this.type, propValue);
            }
            catch (Exception e) {
                logger.error((MessageKey)MsgKey.UTIL_CONFIG_EXCEPTION_LOADING_PROPERTY, e, this.type, this.property, propValue, e.getLocalizedMessage());
            }
        } else {
            if (this.isRequired) {
                throw new RuntimeException(MessageBundle.localizeMessage(MsgKey.UTIL_CONFIG_PROPERTY_IS_NULL, this.property));
            }
            logger.debug((MessageKey)MsgKey.UTIL_CONFIG_PROPERTY_IS_NULL, this.property);
        }
        return value;
    }

    public static ConfigProperty<String> stringProperty(String property) {
        return new ConfigProperty<String>(String.class, property);
    }

    public static ConfigProperty<String> stringProperty(String property, String defaultValue) {
        return new ConfigProperty<String>(String.class, property, defaultValue);
    }

    public static ConfigProperty<Boolean> booleanProperty(String property) {
        return new ConfigProperty<Boolean>(Boolean.class, property);
    }

    public static ConfigProperty<Boolean> booleanProperty(String property, Boolean defaultValue) {
        return new ConfigProperty<Boolean>(Boolean.class, property, defaultValue);
    }

    public static ConfigProperty<Integer> intProperty(String property) {
        return new ConfigProperty<Integer>(Integer.class, property);
    }

    public static ConfigProperty<Integer> intProperty(String property, Integer defaultValue) {
        return new ConfigProperty<Integer>(Integer.class, property, defaultValue);
    }

    public static ConfigProperty<Long> longProperty(String property) {
        return new ConfigProperty<Long>(Long.class, property);
    }

    public static ConfigProperty<Long> longProperty(String property, Long defaultValue) {
        return new ConfigProperty<Long>(Long.class, property, defaultValue);
    }

    public static ConfigProperty<Double> doubleProperty(String property) {
        return new ConfigProperty<Double>(Double.class, property);
    }

    public static ConfigProperty<Double> doubleProperty(String property, Double defaultValue) {
        return new ConfigProperty<Double>(Double.class, property, defaultValue);
    }

    public static ConfigProperty<Float> floatProperty(String property) {
        return new ConfigProperty<Float>(Float.class, property);
    }

    public static ConfigProperty<Float> floatProperty(String property, Float defaultValue) {
        return new ConfigProperty<Float>(Float.class, property, defaultValue);
    }

    public static ConfigProperty<File> fileProperty(String property) {
        return new FileProperty(property);
    }

    public static ConfigProperty<File> fileProperty(String property, File defaultValue) {
        return new FileProperty(property, defaultValue);
    }

    public static ConfigProperty<Interval> intervalProperty(String property) {
        return new ConfigProperty<Interval>(Interval.class, property);
    }

    public static ConfigProperty<Interval> intervalProperty(String property, Interval defaultValue) {
        return new ConfigProperty<Interval>(Interval.class, property, defaultValue);
    }

    public static ConfigProperty<Interval> intervalProperty(String property, String defaultValue) {
        return new ConfigProperty<Interval>(Interval.class, property, new Interval(defaultValue));
    }

    public String toString() {
        return this.property;
    }
}

