/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.common.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.rmi.dgc.VMID;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class GUID
implements Serializable,
Comparable {
    private static final String VALID_ID_REGEX = "[0-9a-f]{32}";
    private static final long serialVersionUID = 1L;
    private String value;

    public GUID() {
        this.value = GUID.generateHexId();
    }

    public GUID(String guid) {
        this.value = guid.toLowerCase();
        if (!GUID.isId(this.value)) {
            throw new IllegalArgumentException("GUID must only contain hexadecimal characters");
        }
    }

    public static boolean isId(String id) {
        return id != null && id.toLowerCase().matches(VALID_ID_REGEX);
    }

    public boolean equals(Object o) {
        if (o instanceof GUID) {
            return this.value.equals(((GUID)o).value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value;
    }

    private static String generateHexId() {
        try {
            String id = new VMID().toString();
            MessageDigest md5Digest = MessageDigest.getInstance("MD5");
            byte[] clientIdHash = md5Digest.digest(id.getBytes(Charset.defaultCharset()));
            return GUID.byteArrayToHexString(clientIdHash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not create ID", e);
        }
    }

    @SuppressWarnings(value={"BSHIFT"})
    protected static String byteArrayToHexString(byte[] in) {
        byte ch = 0;
        if (in == null || in.length <= 0) {
            return null;
        }
        String[] pseudo = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
        StringBuffer out = new StringBuffer(in.length * 2);
        for (int i = 0; i < in.length; ++i) {
            ch = (byte)(in[i] & 0xF0);
            ch = (byte)(ch >>> 4);
            ch = (byte)(ch & 0xF);
            out.append(pseudo[ch]);
            ch = (byte)(in[i] & 0xF);
            out.append(pseudo[ch]);
        }
        return new String(out);
    }

    public int compareTo(Object o) {
        if (o instanceof GUID) {
            return this.value.compareTo(((GUID)o).value);
        }
        if (o instanceof String) {
            return this.value.compareTo((String)o);
        }
        throw new ClassCastException("Cannot compare type " + o.getClass() + " to " + this.getClass());
    }
}

