/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.common.util;

import com.netapp.common.logging.NALogger;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class MulticastProxy<T>
implements InvocationHandler {
    private Iterable<? extends T> targets;

    private MulticastProxy(Iterable<? extends T> targets) {
        this.targets = targets;
    }

    public static <T> T createMulticastProxy(Class<T> clazz, Iterable<? extends T> targets) {
        MulticastProxy<? extends T> h = new MulticastProxy<T>(targets);
        return clazz.cast(Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, h));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == Object.class && method.getName().equals("finalize")) {
            return null;
        }
        for (T listener : this.targets) {
            try {
                method.invoke(listener, args);
            }
            catch (Throwable t) {
                NALogger.getLogger(MulticastProxy.class).internal("Exception caught in MulticastProxy for %s: %s", t, method.toString(), t.getLocalizedMessage());
            }
        }
        return null;
    }
}

