/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.common.util;

import java.io.File;
import java.io.FileFilter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexFileFilter
implements FileFilter {
    private String regex;
    private FileType fileType;
    private Pattern regexPattern;

    public RegexFileFilter() {
        this.fileType = FileType.ALL;
    }

    public RegexFileFilter(String regex, FileType fileType) {
        this.regex = regex;
        this.fileType = fileType;
        this.regexPattern = Pattern.compile(this.regex);
    }

    public void setRegex(String regex) {
        this.regex = regex;
        this.regexPattern = Pattern.compile(this.regex);
    }

    @Override
    public boolean accept(File file) {
        return this.matchesName(file.getName()) && this.matchesType(file);
    }

    private boolean matchesName(String fileName) {
        Matcher matcher = this.regexPattern.matcher(fileName);
        return matcher.matches();
    }

    private boolean matchesType(File file) {
        if (FileType.ALL.equals((Object)this.fileType)) {
            return true;
        }
        if (FileType.FILE.equals((Object)this.fileType)) {
            return file.isFile();
        }
        return file.isDirectory();
    }

    public static enum FileType {
        FILE,
        DIRECTORY,
        ALL;

    }
}

