/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.common.xml;

import com.netapp.common.MsgKey;
import com.netapp.common.logging.MessageBundle;
import com.netapp.common.logging.NALogger;
import com.netapp.common.xml.NoSuchResourceException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MapEntityResolver
implements EntityResolver,
LSResourceResolver {
    private static final NALogger logger = NALogger.getLogger(MapEntityResolver.class);
    private Map<String, Entry> map = new HashMap<String, Entry>();

    public void addMapping(String systemId, String resource) throws NoSuchResourceException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        this.addMapping(systemId, resource, classLoader);
    }

    public void addMapping(String systemId, String resource, ClassLoader classLoader) throws NoSuchResourceException {
        if (classLoader.getResource(resource) == null) {
            throw new NoSuchResourceException(MessageBundle.localizeMessage(MsgKey.XML_RESOLVER_NO_SUCH_RESOURCE, resource, systemId));
        }
        this.map.put(systemId, new Entry(resource, classLoader));
    }

    public InputStream getInputStream(String systemId) {
        Entry entry = this.map.get(systemId);
        return entry != null ? entry.getInputStream() : null;
    }

    public Source getSource(String systemId) {
        Entry entry = this.map.get(systemId);
        if (entry != null) {
            logger.internal("getSource(%s) -> %s", systemId, entry.resource);
            StreamSource source = new StreamSource(entry.getInputStream(), systemId);
            return source;
        }
        return new StreamSource(systemId);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        Entry entry = this.map.get(systemId);
        if (entry != null) {
            logger.internal("resolveEntity(%s, %s) => %s", publicId, systemId, entry);
            return new InputSource(entry.getInputStream());
        }
        logger.internal("resolveEntity(%s, %s) UNKNOWN", publicId, systemId);
        return null;
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        logger.internal("resolveResource(%s, %s, %s, %s, %s)", type, namespaceURI, publicId, systemId, baseURI);
        Entry entry = this.map.get(namespaceURI);
        if (entry == null) {
            entry = this.map.get(systemId);
        }
        if (entry == null) {
            entry = this.map.get(baseURI);
        }
        if (entry != null) {
            LSInputImpl input = new LSInputImpl();
            input.setBaseURI(baseURI);
            input.setPublicId(publicId);
            input.setSystemId(systemId);
            input.setByteStream(entry.getInputStream());
            return input;
        }
        return null;
    }

    private static class LSInputImpl
    implements LSInput {
        private String publicId;
        private String systemId;
        private String baseURI;
        private InputStream inputStream;

        LSInputImpl() {
        }

        @Override
        public String getBaseURI() {
            return this.baseURI;
        }

        @Override
        public InputStream getByteStream() {
            return this.inputStream;
        }

        @Override
        public boolean getCertifiedText() {
            return false;
        }

        @Override
        public Reader getCharacterStream() {
            return null;
        }

        @Override
        public String getEncoding() {
            return null;
        }

        @Override
        public String getPublicId() {
            return this.publicId;
        }

        @Override
        public String getStringData() {
            return null;
        }

        @Override
        public String getSystemId() {
            return this.systemId;
        }

        @Override
        public void setBaseURI(String arg0) {
            this.baseURI = arg0;
        }

        @Override
        public void setByteStream(InputStream arg0) {
            this.inputStream = arg0;
        }

        @Override
        public void setCertifiedText(boolean arg0) {
        }

        @Override
        public void setCharacterStream(Reader arg0) {
        }

        @Override
        public void setEncoding(String arg0) {
        }

        @Override
        public void setPublicId(String arg0) {
            this.publicId = arg0;
        }

        @Override
        public void setStringData(String arg0) {
        }

        @Override
        public void setSystemId(String arg0) {
            this.systemId = arg0;
        }
    }

    private static class Entry {
        private String resource;
        private ClassLoader classLoader;

        protected Entry(String resource, ClassLoader classLoader) {
            this.resource = resource;
            this.classLoader = classLoader;
        }

        protected InputStream getInputStream() {
            return this.classLoader.getResourceAsStream(this.resource);
        }

        protected URL getLocalURL() {
            return this.classLoader.getResource(this.resource);
        }

        public String toString() {
            return this.resource;
        }
    }
}

