/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class AbstractClassEmptyMethods
extends BytecodeScanningDetector {
    private static JavaClass EXCEPTION_CLASS;
    private final BugReporter bugReporter;
    private String methodName;
    private State state;

    public AbstractClassEmptyMethods(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass cls = classContext.getJavaClass();
        if (cls.isAbstract()) {
            super.visitClassContext(classContext);
        }
    }

    public void visitMethod(Method obj) {
        this.methodName = obj.getName();
        this.state = State.SAW_NOTHING;
    }

    public void visitCode(Code obj) {
        if ("<init>".equals(this.methodName) || "<clinit>".equals(this.methodName)) {
            return;
        }
        super.visitCode(obj);
    }

    public void sawOpcode(int seen) {
        try {
            switch (this.state) {
                case SAW_NOTHING: {
                    if (seen == 177) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, "ACEM_ABSTRACT_CLASS_EMPTY_METHODS", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                        this.state = State.SAW_DONE;
                        break;
                    }
                    if (seen == 187) {
                        String newClass = this.getClassConstantOperand();
                        JavaClass exCls = Repository.lookupClass((String)newClass);
                        if (EXCEPTION_CLASS != null && exCls.instanceOf(EXCEPTION_CLASS)) {
                            this.state = State.SAW_NEW;
                            break;
                        }
                        this.state = State.SAW_DONE;
                        break;
                    }
                    this.state = State.SAW_DONE;
                    break;
                }
                case SAW_NEW: {
                    if (seen == 89) {
                        this.state = State.SAW_DUP;
                        break;
                    }
                    this.state = State.SAW_DONE;
                    break;
                }
                case SAW_DUP: {
                    if ((seen == 18 || seen == 19) && this.getConstantRefOperand() instanceof ConstantString) {
                        this.state = State.SAW_LDC;
                        break;
                    }
                    this.state = State.SAW_DONE;
                    break;
                }
                case SAW_LDC: {
                    if (seen == 183 && "<init>".equals(this.getNameConstantOperand())) {
                        this.state = State.SAW_INVOKESPECIAL;
                        break;
                    }
                    this.state = State.SAW_DONE;
                    break;
                }
                case SAW_INVOKESPECIAL: {
                    if (seen == 191) {
                        this.bugReporter.reportBug(new BugInstance("ACEM_ABSTRACT_CLASS_EMPTY_METHODS", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    }
                    this.state = State.SAW_DONE;
                    break;
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
            this.state = State.SAW_DONE;
        }
    }

    static {
        try {
            EXCEPTION_CLASS = Repository.lookupClass((String)"java.lang.Exception");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        SAW_NOTHING,
        SAW_NEW,
        SAW_DUP,
        SAW_LDC,
        SAW_INVOKESPECIAL,
        SAW_DONE;

    }
}

