/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.ArrayList;
import java.util.List;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.generic.Type;

public class ArrayBasedCollections
extends BytecodeScanningDetector {
    private BugReporter bugReporter;
    private OpcodeStack stack;
    private List<BugInstance> mapBugs;
    private List<BugInstance> setBugs;
    private boolean hasMapComparator;
    private boolean hasSetComparator;

    public ArrayBasedCollections(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            this.mapBugs = new ArrayList<BugInstance>();
            this.setBugs = new ArrayList<BugInstance>();
            this.hasMapComparator = false;
            this.hasSetComparator = false;
            super.visitClassContext(classContext);
            if (!this.hasMapComparator) {
                for (BugInstance bi : this.mapBugs) {
                    this.bugReporter.reportBug(bi);
                }
            }
            if (!this.hasSetComparator) {
                for (BugInstance bi : this.setBugs) {
                    this.bugReporter.reportBug(bi);
                }
            }
        }
        finally {
            this.stack = null;
            this.mapBugs = null;
            this.setBugs = null;
        }
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        super.visitCode(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        try {
            this.stack.precomputation((DismantleBytecode)this);
            if (seen == 185) {
                String pushedSig;
                OpcodeStack.Item itm;
                String className = this.getClassConstantOperand();
                String methodName = this.getNameConstantOperand();
                String methodSig = this.getSigConstantOperand();
                boolean found = false;
                List<BugInstance> bugList = null;
                if ("java/util/Map".equals(className) && "put".equals(methodName) && "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;".equals(methodSig)) {
                    String pushedSig2;
                    if (this.stack.getStackDepth() > 1 && (pushedSig2 = (itm = this.stack.getStackItem(1)).getSignature()).length() > 0 && pushedSig2.charAt(0) == '[') {
                        bugList = this.mapBugs;
                        found = true;
                    }
                } else if ("java/util/Set".equals(className) && "add".equals(methodName) && "(Ljava/lang/Object;)Z".equals(methodSig)) {
                    String pushedSig3;
                    if (this.stack.getStackDepth() > 0 && (pushedSig3 = (itm = this.stack.getStackItem(0)).getSignature()).charAt(0) == '[') {
                        bugList = this.setBugs;
                        found = true;
                    }
                } else if ("java/util/List".equals(className) && "contains".equals(methodName) && "(Ljava/lang/Object;)Z".equals(methodSig) && this.stack.getStackDepth() > 0 && (pushedSig = (itm = this.stack.getStackItem(0)).getSignature()).charAt(0) == '[') {
                    found = true;
                }
                if (found) {
                    BugInstance bi = new BugInstance((Detector)this, "ABC_ARRAY_BASED_COLLECTIONS", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this);
                    if (bugList != null) {
                        bugList.add(bi);
                    } else {
                        this.bugReporter.reportBug(bi);
                    }
                }
            } else if (seen == 183) {
                String className = this.getClassConstantOperand();
                String methodName = this.getNameConstantOperand();
                String sig = this.getSigConstantOperand();
                if ("<init>".equals(methodName)) {
                    Type[] parms;
                    if (!this.hasMapComparator && "java/util/TreeMap".equals(className)) {
                        Type[] parms2 = Type.getArgumentTypes((String)sig);
                        if (parms2.length == 1 && "Ljava/util/Comparator;".equals(parms2[0].getSignature())) {
                            this.hasMapComparator = true;
                        }
                    } else if (!this.hasSetComparator && "java/util/TreeSet".equals(className) && (parms = Type.getArgumentTypes((String)sig)).length == 1 && "Ljava/util/Comparator;".equals(parms[0].getSignature())) {
                        this.hasSetComparator = true;
                    }
                }
            }
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
        }
    }
}

