/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Visitor;

public class CloneUsability
extends PreorderVisitor
implements Detector {
    private static JavaClass CLONE_CLASS;
    private BugReporter bugReporter;
    private JavaClass cls;
    private String clsName;

    public CloneUsability(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.cls = classContext.getJavaClass();
            if (this.cls.implementationOf(CLONE_CLASS)) {
                this.clsName = this.cls.getClassName();
                this.cls.accept((Visitor)this);
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
        finally {
            this.cls = null;
        }
    }

    public void visitMethod(Method obj) {
        try {
            if (obj.isPublic() && !obj.isSynthetic() && obj.getName().equals("clone") && obj.getArgumentTypes().length == 0) {
                ExceptionTable et;
                String returnClsName = obj.getReturnType().getSignature();
                if (!this.clsName.equals(returnClsName = returnClsName.substring(1, returnClsName.length() - 1).replaceAll("/", "."))) {
                    if ("java.lang.Object".equals(returnClsName)) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, "CU_CLONE_USABILITY_OBJECT_RETURN", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this));
                    } else {
                        JavaClass cloneClass = Repository.lookupClass((String)returnClsName);
                        if (!this.cls.instanceOf(cloneClass)) {
                            this.bugReporter.reportBug(new BugInstance((Detector)this, "CU_CLONE_USABILITY_MISMATCHED_RETURN", 1).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this));
                        }
                    }
                }
                if ((et = obj.getExceptionTable()) != null && et.getLength() > 0) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "CU_CLONE_USABILITY_THROWS", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this));
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
    }

    public void report() {
    }

    static {
        try {
            CLONE_CLASS = Repository.lookupClass((String)"java.lang.Cloneable");
        }
        catch (ClassNotFoundException cnfe) {
            CLONE_CLASS = null;
        }
    }
}

