/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.graph.AbstractVertex;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldCouldBeLocal
extends BytecodeScanningDetector {
    private final BugReporter bugReporter;
    private ClassContext clsContext;
    private Map<String, FieldInfo> localizableFields;
    private CFG cfg;
    private ConstantPoolGen cpg;
    private BitSet visitedBlocks;

    public FieldCouldBeLocal(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.localizableFields = new HashMap<String, FieldInfo>();
            this.visitedBlocks = new BitSet();
            this.clsContext = classContext;
            JavaClass cls = classContext.getJavaClass();
            Field[] fields = cls.getFields();
            ConstantPool cp = classContext.getConstantPoolGen().getConstantPool();
            for (Field f : fields) {
                if (f.isStatic() || f.getName().indexOf(36) >= 0 || !f.isPrivate()) continue;
                FieldAnnotation fa = new FieldAnnotation(cls.getClassName(), f.getName(), f.getSignature(), false);
                boolean hasExternalAnnotation = false;
                for (AnnotationEntry entry : f.getAnnotationEntries()) {
                    ConstantUtf8 cutf = (ConstantUtf8)cp.getConstant(entry.getTypeIndex());
                    if (cutf.getBytes().startsWith("java")) continue;
                    hasExternalAnnotation = true;
                    break;
                }
                this.localizableFields.put(f.getName(), new FieldInfo(fa, hasExternalAnnotation));
            }
            if (this.localizableFields.size() > 0) {
                super.visitClassContext(classContext);
                for (FieldInfo fi : this.localizableFields.values()) {
                    FieldAnnotation fa = fi.getFieldAnnotation();
                    SourceLineAnnotation sla = fi.getSrcLineAnnotation();
                    BugInstance bug = new BugInstance((Detector)this, "FCBL_FIELD_COULD_BE_LOCAL", 2).addClass((PreorderVisitor)this).addField(fa);
                    if (sla != null) {
                        bug.addSourceLine(sla);
                    }
                    this.bugReporter.reportBug(bug);
                }
            }
        }
        finally {
            this.localizableFields = null;
            this.visitedBlocks = null;
            this.clsContext = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitMethod(Method obj) {
        if (this.localizableFields.isEmpty()) {
            return;
        }
        try {
            this.cfg = this.clsContext.getCFG(obj);
            this.cpg = this.cfg.getMethodGen().getConstantPool();
            BasicBlock bb = this.cfg.getEntry();
            HashSet<String> uncheckedFields = new HashSet<String>(this.localizableFields.keySet());
            this.visitedBlocks.clear();
            this.checkBlock(bb, uncheckedFields);
        }
        catch (CFGBuilderException cbe) {
            this.localizableFields.clear();
        }
        finally {
            this.cfg = null;
            this.cpg = null;
        }
    }

    public boolean prescreen(Method method) {
        BitSet bytecodeSet = this.getClassContext().getBytecodeSet(method);
        return bytecodeSet != null && (bytecodeSet.get(181) || bytecodeSet.get(180));
    }

    public void visitCode(Code obj) {
        String methodName;
        Method m = this.getMethod();
        if (this.prescreen(m) && ("<clinit".equals(methodName = m.getName()) || "<init>".equals(methodName))) {
            super.visitCode(obj);
        }
    }

    public void sawOpcode(int seen) {
        String fieldName;
        FieldInfo fi;
        if ((seen == 180 || seen == 181) && (fi = this.localizableFields.get(fieldName = this.getNameConstantOperand())) != null) {
            SourceLineAnnotation sla = SourceLineAnnotation.fromVisitedInstruction((BytecodeScanningDetector)this);
            fi.setSrcLineAnnotation(sla);
        }
    }

    private void checkBlock(BasicBlock bb, Set<String> uncheckedFields) {
        LinkedList<BlockState> toBeProcessed = new LinkedList<BlockState>();
        toBeProcessed.add(new BlockState(bb, uncheckedFields));
        this.visitedBlocks.set(bb.getLabel());
        while (!toBeProcessed.isEmpty()) {
            if (this.localizableFields.isEmpty()) {
                return;
            }
            BlockState bState = (BlockState)toBeProcessed.removeFirst();
            bb = bState.getBasicBlock();
            BasicBlock.InstructionIterator ii = bb.instructionIterator();
            while (bState.getUncheckedFieldSize() > 0 && ii.hasNext()) {
                INVOKESPECIAL is;
                InstructionHandle ih = ii.next();
                Instruction ins = ih.getInstruction();
                if (ins instanceof FieldInstruction) {
                    FieldInstruction fi = (FieldInstruction)ins;
                    String fieldName = fi.getFieldName(this.cpg);
                    FieldInfo finfo = this.localizableFields.get(fieldName);
                    if (finfo != null && this.localizableFields.get(fieldName).hasAnnotation()) {
                        this.localizableFields.remove(fieldName);
                        continue;
                    }
                    boolean justRemoved = bState.removeUncheckedField(fieldName);
                    if (ins instanceof GETFIELD) {
                        if (!justRemoved) continue;
                        this.localizableFields.remove(fieldName);
                        if (!this.localizableFields.isEmpty()) continue;
                        return;
                    }
                    if (finfo == null) continue;
                    finfo.setSrcLineAnnotation(SourceLineAnnotation.fromVisitedInstruction((ClassContext)this.clsContext, (PreorderVisitor)this, (int)ih.getPosition()));
                    continue;
                }
                if (!(ins instanceof INVOKESPECIAL) || !"<init>".equals((is = (INVOKESPECIAL)ins).getMethodName(this.cpg)) || !is.getClassName(this.cpg).startsWith(this.clsContext.getJavaClass().getClassName() + "$")) continue;
                this.localizableFields.clear();
            }
            if (bState.getUncheckedFieldSize() <= 0) continue;
            Iterator oei = this.cfg.outgoingEdgeIterator((AbstractVertex)bb);
            while (oei.hasNext()) {
                Edge e = (Edge)oei.next();
                BasicBlock cb = (BasicBlock)e.getTarget();
                int label = cb.getLabel();
                if (this.visitedBlocks.get(label)) continue;
                toBeProcessed.addLast(new BlockState(cb, bState));
                this.visitedBlocks.set(label);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BlockState {
        private final BasicBlock basicBlock;
        private Set<String> uncheckedFields;
        private boolean fieldsAreSharedWithParent;

        public BlockState(BasicBlock bb, Set<String> fields) {
            this.basicBlock = bb;
            this.uncheckedFields = fields;
            this.fieldsAreSharedWithParent = true;
        }

        public BlockState(BasicBlock bb, BlockState parentBlockState) {
            this.basicBlock = bb;
            this.uncheckedFields = parentBlockState.uncheckedFields;
            this.fieldsAreSharedWithParent = true;
        }

        public BasicBlock getBasicBlock() {
            return this.basicBlock;
        }

        public int getUncheckedFieldSize() {
            return this.uncheckedFields == null ? 0 : this.uncheckedFields.size();
        }

        public boolean removeUncheckedField(String field) {
            if (this.uncheckedFields != null && this.uncheckedFields.contains(field)) {
                if (this.uncheckedFields.size() == 1) {
                    this.uncheckedFields = null;
                    this.fieldsAreSharedWithParent = false;
                    return true;
                }
                if (this.fieldsAreSharedWithParent) {
                    this.uncheckedFields = new HashSet<String>(this.uncheckedFields);
                    this.fieldsAreSharedWithParent = false;
                    this.uncheckedFields.remove(field);
                    return true;
                }
                this.uncheckedFields.remove(field);
                return true;
            }
            return false;
        }

        public String toString() {
            return this.basicBlock + "|" + this.uncheckedFields;
        }
    }

    private static class FieldInfo {
        private final FieldAnnotation fieldAnnotation;
        private SourceLineAnnotation srcLineAnnotation;
        private boolean hasAnnotation;

        public FieldInfo(FieldAnnotation fa, boolean hasExternalAnnotation) {
            this.fieldAnnotation = fa;
            this.srcLineAnnotation = null;
            this.hasAnnotation = hasExternalAnnotation;
        }

        public void setSrcLineAnnotation(SourceLineAnnotation sla) {
            if (this.srcLineAnnotation == null) {
                this.srcLineAnnotation = sla;
            }
        }

        public FieldAnnotation getFieldAnnotation() {
            return this.fieldAnnotation;
        }

        public SourceLineAnnotation getSrcLineAnnotation() {
            return this.srcLineAnnotation;
        }

        public boolean hasAnnotation() {
            return this.hasAnnotation;
        }
    }
}

