/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import com.mebigfatguy.fbcontrib.utils.TernaryPatcher;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

@OpcodeStack.CustomUserValue
public class JDBCVendorReliance
extends BytecodeScanningDetector {
    private BugReporter bugReporter;
    private OpcodeStack stack;
    private Map<Integer, Integer> jdbcLocals = new HashMap<Integer, Integer>();

    public JDBCVendorReliance(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        this.stack = new OpcodeStack();
        this.jdbcLocals = new HashMap<Integer, Integer>();
        super.visitClassContext(classContext);
        this.stack = null;
        this.jdbcLocals = null;
    }

    public void visitMethod(Method obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        this.jdbcLocals.clear();
        int[] parmRegs = RegisterUtils.getParameterRegisters(obj);
        Type[] argTypes = obj.getArgumentTypes();
        for (int t = 0; t < argTypes.length; ++t) {
            String sig = argTypes[t].getSignature();
            if (!this.isJDBCClass(sig)) continue;
            this.jdbcLocals.put(parmRegs[t], RegisterUtils.getLocalVariableEndRange(obj.getLocalVariableTable(), parmRegs[t], 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        boolean tosIsJDBC = false;
        try {
            int reg;
            String clsName;
            this.stack.precomputation((DismantleBytecode)this);
            int curPC = this.getPC();
            Iterator<Integer> it = this.jdbcLocals.values().iterator();
            while (it.hasNext()) {
                Integer endPCRange = it.next();
                if (endPCRange >= curPC) continue;
                it.remove();
            }
            if (!(seen != 182 && seen != 185 || "java/lang/Object".equals(clsName = this.getClassConstantOperand()) || this.isJDBCClass(clsName))) {
                OpcodeStack.Item itm;
                int parmCnt = Type.getArgumentTypes((String)this.getSigConstantOperand()).length;
                if (this.stack.getStackDepth() > parmCnt && (itm = this.stack.getStackItem(parmCnt)).getUserValue() != null) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "JVR_JDBC_VENDOR_RELIANCE", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    return;
                }
            }
            if (seen == 185) {
                String sig;
                Type retType;
                String infName = this.getClassConstantOperand();
                if (this.isJDBCClass(infName) && this.isJDBCClass(infName = (retType = Type.getReturnType((String)(sig = this.getSigConstantOperand()))).getSignature())) {
                    tosIsJDBC = true;
                }
            } else if (seen == 58 || seen >= 75 && seen <= 78) {
                OpcodeStack.Item itm;
                if (this.stack.getStackDepth() > 0 && (itm = this.stack.getStackItem(0)).getUserValue() != null) {
                    int reg2 = RegisterUtils.getAStoreReg((DismantleBytecode)this, seen);
                    this.jdbcLocals.put(reg2, RegisterUtils.getLocalVariableEndRange(this.getMethod().getLocalVariableTable(), reg2, this.getNextPC()));
                }
            } else if ((seen == 25 || seen >= 42 && seen <= 45) && this.jdbcLocals.containsKey(reg = RegisterUtils.getALoadReg((DismantleBytecode)this, seen))) {
                tosIsJDBC = true;
            }
        }
        finally {
            TernaryPatcher.pre(this.stack, seen);
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            TernaryPatcher.post(this.stack, seen);
            if (tosIsJDBC && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item itm = this.stack.getStackItem(0);
                itm.setUserValue((Object)Boolean.TRUE);
            }
        }
    }

    private boolean isJDBCClass(String clsName) {
        if (clsName.endsWith(";")) {
            clsName = clsName.substring(1, clsName.length() - 1);
        }
        if (!(clsName = clsName.replace('.', '/')).startsWith("java/sql/") && !clsName.startsWith("javax/sql/")) {
            return false;
        }
        return !clsName.endsWith("Exception");
    }
}

