/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.TernaryPatcher;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.RuntimeVisibleAnnotations;
import org.apache.bcel.classfile.Unknown;
import org.apache.bcel.generic.Type;

@OpcodeStack.CustomUserValue
public class JUnitAssertionOddities
extends BytecodeScanningDetector {
    private static final String RUNTIME_VISIBLE_ANNOTATIONS = "RuntimeVisibleAnnotations";
    private static final String TESTCASE_CLASS = "junit.framework.TestCase";
    private static final String TEST_CLASS = "org.junit.Test";
    private static final String TEST_ANNOTATION_SIGNATURE = "Lorg/junit/Test;";
    private static final String OLD_ASSERT_CLASS = "junit/framework/Assert";
    private static final String NEW_ASSERT_CLASS = "org/junit/Assert";
    private BugReporter bugReporter;
    private JavaClass testCaseClass;
    private JavaClass testAnnotationClass;
    private OpcodeStack stack;
    private boolean isTestCaseDerived;
    private boolean isAnnotationCapable;
    private State state;

    public JUnitAssertionOddities(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        try {
            this.testCaseClass = Repository.lookupClass((String)TESTCASE_CLASS);
        }
        catch (ClassNotFoundException cnfe) {
            this.testCaseClass = null;
            bugReporter.reportMissingClass(DescriptorFactory.createClassDescriptor((String)TESTCASE_CLASS.replaceAll("\\.", "/")));
        }
        try {
            this.testAnnotationClass = Repository.lookupClass((String)TEST_CLASS);
        }
        catch (ClassNotFoundException cnfe) {
            this.testAnnotationClass = null;
            bugReporter.reportMissingClass(DescriptorFactory.createClassDescriptor((String)TEST_CLASS.replaceAll("\\.", "/")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            JavaClass cls = classContext.getJavaClass();
            this.isTestCaseDerived = this.testCaseClass != null && cls.instanceOf(this.testCaseClass);
            boolean bl = this.isAnnotationCapable = cls.getMajor() >= 5 && this.testAnnotationClass != null;
            if (this.isTestCaseDerived || this.isAnnotationCapable) {
                this.stack = new OpcodeStack();
                super.visitClassContext(classContext);
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
        finally {
            this.stack = null;
        }
    }

    public void visitCode(Code obj) {
        boolean isTestMethod;
        Method m = this.getMethod();
        boolean bl = isTestMethod = this.isTestCaseDerived && m.getName().startsWith("test");
        if (!isTestMethod && this.isAnnotationCapable) {
            Attribute[] atts;
            block0: for (Attribute att : atts = m.getAttributes()) {
                AnnotationEntry[] entries;
                String name;
                ConstantPool cp = att.getConstantPool();
                Constant c = cp.getConstant(att.getNameIndex());
                if (!(c instanceof ConstantUtf8) || !RUNTIME_VISIBLE_ANNOTATIONS.equals(name = ((ConstantUtf8)c).getBytes())) continue;
                if (att instanceof Unknown) {
                    Unknown unAtt = (Unknown)att;
                    byte[] bytes = unAtt.getBytes();
                    int constantPoolIndex = bytes[3] & 0xFF;
                    c = cp.getConstant(constantPoolIndex);
                    if (!(c instanceof ConstantUtf8) || !TEST_ANNOTATION_SIGNATURE.equals(name = ((ConstantUtf8)c).getBytes())) continue;
                    isTestMethod = true;
                    break;
                }
                if (!(att instanceof RuntimeVisibleAnnotations)) continue;
                RuntimeVisibleAnnotations rva = (RuntimeVisibleAnnotations)att;
                for (AnnotationEntry entry : entries = rva.getAnnotationEntries()) {
                    if (!TEST_ANNOTATION_SIGNATURE.equals(entry.getAnnotationType())) continue;
                    isTestMethod = true;
                    continue block0;
                }
            }
        }
        if (isTestMethod) {
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            this.state = State.SAW_NOTHING;
            super.visitCode(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void sawOpcode(int seen) {
        block29: {
            block30: {
                block26: {
                    block28: {
                        block27: {
                            userValue = null;
                            try {
                                this.stack.precomputation((DismantleBytecode)this);
                                if (seen != 184) ** GOTO lbl69
                                clsName = this.getClassConstantOperand();
                                if (!"junit/framework/Assert".equals(clsName) && !"org/junit/Assert".equals(clsName)) ** GOTO lbl64
                                methodName = this.getNameConstantOperand();
                                if (!"assertEquals".equals(methodName)) ** GOTO lbl57
                                signature = this.getSigConstantOperand();
                                argTypes = Type.getArgumentTypes((String)signature);
                                if (argTypes.length != 2 && argTypes.length != 3 || this.stack.getStackDepth() < 2) break block26;
                                item1 = this.stack.getStackItem(1);
                                cons1 = item1.getConstant();
                                if (cons1 == null || !argTypes[argTypes.length - 1].equals((Object)Type.BOOLEAN) || !argTypes[argTypes.length - 2].equals((Object)Type.BOOLEAN)) break block27;
                                this.bugReporter.reportBug(new BugInstance((Detector)this, "JAO_JUNIT_ASSERTION_ODDITIES_BOOLEAN_ASSERT", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                            }
                            catch (Throwable var11_14) {
                                TernaryPatcher.pre(this.stack, seen);
                                this.stack.sawOpcode((DismantleBytecode)this, seen);
                                TernaryPatcher.post(this.stack, seen);
                                if (userValue != null && this.stack.getStackDepth() > 0) {
                                    item = this.stack.getStackItem(0);
                                    item.setUserValue(userValue);
                                }
                                throw var11_14;
                            }
                            TernaryPatcher.pre(this.stack, seen);
                            this.stack.sawOpcode((DismantleBytecode)this, seen);
                            TernaryPatcher.post(this.stack, seen);
                            if (userValue != null && this.stack.getStackDepth() > 0) {
                                item = this.stack.getStackItem(0);
                                item.setUserValue((Object)userValue);
                            }
                            return;
                        }
                        item0 = this.stack.getStackItem(0);
                        if (item0.getConstant() == null || item1.getConstant() != null || argTypes.length != 2 && this.isFloatingPtPrimitive(item0.getSignature())) break block28;
                        this.bugReporter.reportBug(new BugInstance((Detector)this, "JAO_JUNIT_ASSERTION_ODDITIES_ACTUAL_CONSTANT", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                        TernaryPatcher.pre(this.stack, seen);
                        this.stack.sawOpcode((DismantleBytecode)this, seen);
                        TernaryPatcher.post(this.stack, seen);
                        if (userValue != null && this.stack.getStackDepth() > 0) {
                            item = this.stack.getStackItem(0);
                            item.setUserValue((Object)userValue);
                        }
                        return;
                    }
                    if (!argTypes[argTypes.length - 1].equals((Object)Type.OBJECT) || !argTypes[argTypes.length - 2].equals((Object)Type.OBJECT) || !"Ljava/lang/Double;".equals(item0.getSignature()) || !"Ljava/lang/Double;".equals(item1.getSignature())) break block26;
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "JAO_JUNIT_ASSERTION_ODDITIES_INEXACT_DOUBLE", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    TernaryPatcher.pre(this.stack, seen);
                    this.stack.sawOpcode((DismantleBytecode)this, seen);
                    TernaryPatcher.post(this.stack, seen);
                    if (userValue != null && this.stack.getStackDepth() > 0) {
                        item = this.stack.getStackItem(0);
                        item.setUserValue((Object)userValue);
                    }
                    return;
                }
                break block30;
lbl57:
                // 1 sources

                if ("assertNotNull".equals(methodName)) {
                    if (this.stack.getStackDepth() > 0 && "valueOf".equals(this.stack.getStackItem(0).getUserValue())) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, "JAO_JUNIT_ASSERTION_ODDITIES_IMPOSSIBLE_NULL", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    }
                } else if ("assertTrue".equals(methodName) && (this.state == State.SAW_ICONST_0 || this.state == State.SAW_EQUALS)) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "JAO_JUNIT_ASSERTION_ODDITIES_USE_ASSERT_EQUALS", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
                break block30;
lbl64:
                // 1 sources

                methodName = this.getNameConstantOperand();
                sig = this.getSigConstantOperand();
                if (clsName.startsWith("java/lang/") && "valueOf".equals(methodName) && sig.indexOf(")Ljava/lang/") >= 0) {
                    userValue = "valueOf";
                }
                break block30;
lbl69:
                // 1 sources

                if (seen == 191 && this.stack.getStackDepth() > 0 && "Ljava/lang/AssertionError;".equals(throwClass = (item = this.stack.getStackItem(0)).getSignature())) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "JAO_JUNIT_ASSERTION_ODDITIES_ASSERT_USED", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
            }
            switch (1.$SwitchMap$com$mebigfatguy$fbcontrib$detect$JUnitAssertionOddities$State[this.state.ordinal()]) {
                case 1: 
                case 2: {
                    if (seen == 160) {
                        this.state = State.SAW_IF_ICMPNE;
                        break;
                    }
                    this.state = State.SAW_NOTHING;
                    break;
                }
                case 3: {
                    if (seen == 4) {
                        this.state = State.SAW_ICONST_1;
                        break;
                    }
                    this.state = State.SAW_NOTHING;
                    break;
                }
                case 4: {
                    if (seen == 167) {
                        this.state = State.SAW_GOTO;
                        break;
                    }
                    this.state = State.SAW_NOTHING;
                    break;
                }
                case 5: {
                    if (seen == 3) {
                        this.state = State.SAW_ICONST_0;
                        break;
                    }
                    this.state = State.SAW_NOTHING;
                    break;
                }
                default: {
                    this.state = State.SAW_NOTHING;
                }
            }
            if (seen != 182) break block29;
            methodName = this.getNameConstantOperand();
            sig = this.getSigConstantOperand();
            if (!"equals".equals(methodName) || !"(Ljava/lang/Object;)Z".equals(sig)) break block29;
            this.state = State.SAW_EQUALS;
        }
        TernaryPatcher.pre(this.stack, seen);
        this.stack.sawOpcode((DismantleBytecode)this, seen);
        TernaryPatcher.post(this.stack, seen);
        if (userValue != null && this.stack.getStackDepth() > 0) {
            item = this.stack.getStackItem(0);
            item.setUserValue((Object)userValue);
        }
    }

    public boolean isFloatingPtPrimitive(String signature) {
        return "D".equals(signature) || "F".equals(signature);
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$com$mebigfatguy$fbcontrib$detect$JUnitAssertionOddities$State;

        static {
            $SwitchMap$com$mebigfatguy$fbcontrib$detect$JUnitAssertionOddities$State = new int[State.values().length];
            try {
                1.$SwitchMap$com$mebigfatguy$fbcontrib$detect$JUnitAssertionOddities$State[State.SAW_NOTHING.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$mebigfatguy$fbcontrib$detect$JUnitAssertionOddities$State[State.SAW_EQUALS.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$mebigfatguy$fbcontrib$detect$JUnitAssertionOddities$State[State.SAW_IF_ICMPNE.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$mebigfatguy$fbcontrib$detect$JUnitAssertionOddities$State[State.SAW_ICONST_1.ordinal()] = 4;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$mebigfatguy$fbcontrib$detect$JUnitAssertionOddities$State[State.SAW_GOTO.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        SAW_NOTHING,
        SAW_IF_ICMPNE,
        SAW_ICONST_1,
        SAW_GOTO,
        SAW_ICONST_0,
        SAW_EQUALS;

    }
}

