/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;

public class NeedlessCustomSerialization
extends BytecodeScanningDetector {
    private static JavaClass serializableClass;
    private BugReporter bugReporter;
    private boolean inReadObject;
    private boolean inWriteObject;
    private State state;

    public NeedlessCustomSerialization(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            JavaClass cls = classContext.getJavaClass();
            if (serializableClass != null && cls.implementationOf(serializableClass)) {
                super.visitClassContext(classContext);
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
    }

    public void visitCode(Code obj) {
        String nameAndSignature = this.getMethod().getName() + this.getMethod().getSignature();
        if ("readObject(Ljava/io/ObjectInputStream;)V".equals(nameAndSignature)) {
            this.inReadObject = true;
            this.inWriteObject = false;
        } else if ("writeObject(Ljava/io/ObjectOutputStream;)V".equals(nameAndSignature)) {
            this.inReadObject = false;
            this.inWriteObject = true;
        }
        if (this.inReadObject || this.inWriteObject) {
            this.state = State.SEEN_NOTHING;
            super.visitCode(obj);
            if (this.state != State.SEEN_INVALID) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "NCS_NEEDLESS_CUSTOM_SERIALIZATION", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, 1));
            }
        }
    }

    public void sawOpcode(int seen) {
        switch (this.state) {
            case SEEN_NOTHING: {
                if (seen == 43) {
                    this.state = State.SEEN_ALOAD1;
                    break;
                }
                this.state = State.SEEN_INVALID;
                break;
            }
            case SEEN_ALOAD1: {
                this.state = State.SEEN_INVALID;
                if (seen != 182) break;
                String nameAndSignature = this.getNameConstantOperand() + this.getSigConstantOperand();
                if ((!this.inReadObject || !"defaultReadObject()V".equals(nameAndSignature)) && (!this.inWriteObject || !"defaultWriteObject()V".equals(nameAndSignature))) break;
                this.state = State.SEEN_INVOKEVIRTUAL;
                break;
            }
            case SEEN_INVOKEVIRTUAL: {
                if (seen == 177) {
                    this.state = State.SEEN_RETURN;
                    break;
                }
                this.state = State.SEEN_INVALID;
                break;
            }
            case SEEN_RETURN: {
                this.state = State.SEEN_INVALID;
                break;
            }
        }
    }

    static {
        try {
            serializableClass = Repository.lookupClass((String)"java/io/Serializable");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        SEEN_NOTHING,
        SEEN_ALOAD1,
        SEEN_INVOKEVIRTUAL,
        SEEN_RETURN,
        SEEN_INVALID;

    }
}

