/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;

public class NonFunctionalField
extends PreorderVisitor
implements Detector {
    private static JavaClass serializableClass;
    private BugReporter bugReporter;

    public NonFunctionalField(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            JavaClass cls = classContext.getJavaClass();
            if (serializableClass != null && cls.implementationOf(serializableClass)) {
                Field[] fields = cls.getFields();
                this.setupVisitorForClass(cls);
                for (Field f : fields) {
                    if (f.isStatic() || !f.isFinal() || !f.isTransient()) continue;
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "NFF_NON_FUNCTIONAL_FIELD", 2).addClass((PreorderVisitor)this).addField(cls.getClassName(), f.getName(), f.getSignature(), f.getAccessFlags()));
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
    }

    public void report() {
    }

    static {
        try {
            serializableClass = Repository.lookupClass((String)"java/io/Serializable");
        }
        catch (ClassNotFoundException cnfe) {
            serializableClass = null;
        }
    }
}

