/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.bcel.classfile.Code;

@OpcodeStack.CustomUserValue
public class NonProductiveMethodCall
extends BytecodeScanningDetector {
    private static final Set<Pattern> IMMUTABLE_METHODS = new HashSet<Pattern>();
    private BugReporter bugReporter;
    private OpcodeStack stack;

    public NonProductiveMethodCall(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            super.visitClassContext(classContext);
            Object var3_2 = null;
            this.stack = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.stack = null;
            throw throwable;
        }
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        super.visitCode(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        String methodInfo = null;
        try {
            this.stack.precomputation((DismantleBytecode)this);
            block1 : switch (seen) {
                case 182: 
                case 184: 
                case 185: {
                    String sig = this.getSigConstantOperand();
                    if (sig.endsWith("V")) break;
                    methodInfo = this.getClassConstantOperand() + "@" + this.getNameConstantOperand() + this.getSigConstantOperand();
                    break;
                }
                case 87: 
                case 88: {
                    OpcodeStack.Item item;
                    String mInfo;
                    if (this.stack.getStackDepth() <= 0 || (mInfo = (String)(item = this.stack.getStackItem(0)).getUserValue()) == null) break;
                    for (Pattern p : IMMUTABLE_METHODS) {
                        Matcher m = p.matcher(mInfo);
                        if (!m.matches()) continue;
                        this.bugReporter.reportBug(new BugInstance((Detector)this, "NPMC_NON_PRODUCTIVE_METHOD_CALL", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addString(mInfo));
                        break block1;
                    }
                    break;
                }
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            if (methodInfo != null && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item item = this.stack.getStackItem(0);
                item.setUserValue(methodInfo);
            }
            throw throwable;
        }
        this.stack.sawOpcode((DismantleBytecode)this, seen);
        if (methodInfo != null && this.stack.getStackDepth() > 0) {
            OpcodeStack.Item item = this.stack.getStackItem(0);
            item.setUserValue(methodInfo);
        }
    }

    static {
        IMMUTABLE_METHODS.add(Pattern.compile(".*@toString\\(\\)Ljava/lang/String;"));
        IMMUTABLE_METHODS.add(Pattern.compile("java/lang/.+@.+Value\\(\\)[BCDFIJSZ]"));
        IMMUTABLE_METHODS.add(Pattern.compile(".*@equals\\(Ljava/lang/Object;\\)Z"));
        IMMUTABLE_METHODS.add(Pattern.compile(".*@hashCode\\(\\)I"));
        IMMUTABLE_METHODS.add(Pattern.compile(".*@clone\\(\\).+"));
        IMMUTABLE_METHODS.add(Pattern.compile("java/util/.+@toArray\\(\\)\\[.+"));
    }
}

