/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import com.mebigfatguy.fbcontrib.utils.TernaryPatcher;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.generic.Type;

@OpcodeStack.CustomUserValue
public class PossibleConstantAllocationInLoop
extends BytecodeScanningDetector {
    private static final Set<String> SYNTHETIC_ALLOCATION_CLASSES = new HashSet<String>();
    private final BugReporter bugReporter;
    private OpcodeStack stack;
    private Map<Integer, AllocationInfo> allocations;
    private Map<Integer, Integer> storedAllocations;
    private int nextAllocationNumber;

    public PossibleConstantAllocationInLoop(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            this.allocations = new HashMap<Integer, AllocationInfo>();
            this.storedAllocations = new HashMap<Integer, Integer>();
            super.visitClassContext(classContext);
            Object var3_2 = null;
            this.stack = null;
            this.allocations = null;
            this.storedAllocations = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.stack = null;
            this.allocations = null;
            this.storedAllocations = null;
            throw throwable;
        }
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        this.allocations.clear();
        this.storedAllocations.clear();
        this.nextAllocationNumber = 1;
        super.visitCode(obj);
        for (AllocationInfo info : this.allocations.values()) {
            if (info.loopBottom == -1) continue;
            this.bugReporter.reportBug(new BugInstance((Detector)this, "PCAIL_POSSIBLE_CONSTANT_ALLOCATION_IN_LOOP", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine(this.getClassContext(), (PreorderVisitor)this, info.allocationPC));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        block29: {
            boolean sawAllocation = false;
            Integer sawAllocationNumber = null;
            try {
                this.stack.precomputation((DismantleBytecode)this);
                switch (seen) {
                    case 153: 
                    case 154: 
                    case 155: 
                    case 156: 
                    case 157: 
                    case 158: 
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: 
                    case 165: 
                    case 166: 
                    case 167: 
                    case 198: 
                    case 199: 
                    case 200: {
                        if (this.getBranchOffset() >= 0) break;
                        int branchLoc = this.getBranchTarget();
                        int pc = this.getPC();
                        for (AllocationInfo info : this.allocations.values()) {
                            if (info.loopTop != -1 || branchLoc >= info.allocationPC) continue;
                            info.loopTop = branchLoc;
                            info.loopBottom = pc;
                        }
                        break;
                    }
                    case 183: {
                        String clsName;
                        if ("<init>".equals(this.getNameConstantOperand()) && "()V".equals(this.getSigConstantOperand()) && !SYNTHETIC_ALLOCATION_CLASSES.contains(clsName = this.getClassConstantOperand())) {
                            sawAllocationNumber = this.nextAllocationNumber;
                            this.allocations.put(sawAllocationNumber, new AllocationInfo(this.getPC()));
                            sawAllocation = true;
                        }
                    }
                    case 182: 
                    case 184: 
                    case 185: {
                        String retType;
                        String signature = this.getSigConstantOperand();
                        Type[] types = Type.getArgumentTypes((String)signature);
                        if (this.stack.getStackDepth() < types.length) break;
                        for (int i = 0; i < types.length; ++i) {
                            OpcodeStack.Item item = this.stack.getStackItem(i);
                            Integer allocation = (Integer)item.getUserValue();
                            if (allocation == null) continue;
                            this.allocations.remove(allocation);
                        }
                        if (seen != 185 && seen != 182 && seen != 183 || this.stack.getStackDepth() <= types.length) break;
                        OpcodeStack.Item item = this.stack.getStackItem(types.length);
                        Integer allocation = (Integer)item.getUserValue();
                        if (allocation != null && !"V".equals(retType = Type.getReturnType((String)signature).getSignature()) && retType.equals(item.getSignature())) {
                            sawAllocationNumber = allocation;
                            sawAllocation = true;
                        }
                        break;
                    }
                    case 58: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: {
                        if (this.stack.getStackDepth() <= 0) break;
                        OpcodeStack.Item item = this.stack.getStackItem(0);
                        Integer allocation = (Integer)item.getUserValue();
                        if (allocation != null) {
                            Integer reg = RegisterUtils.getAStoreReg((DismantleBytecode)this, seen);
                            if (this.isFirstUse(reg)) {
                                if (this.storedAllocations.values().contains(allocation)) {
                                    this.allocations.remove(allocation);
                                    this.storedAllocations.remove(reg);
                                    break;
                                }
                                if (this.storedAllocations.containsKey(reg)) {
                                    this.allocations.remove(allocation);
                                    allocation = this.storedAllocations.remove(reg);
                                    this.allocations.remove(allocation);
                                    break;
                                }
                                this.storedAllocations.put(reg, allocation);
                                break;
                            }
                            item.setUserValue(null);
                            this.allocations.remove(allocation);
                        }
                        break;
                    }
                    case 83: {
                        if (this.stack.getStackDepth() < 2) break;
                        OpcodeStack.Item item = this.stack.getStackItem(0);
                        Integer allocation = (Integer)item.getUserValue();
                        if (allocation != null) {
                            this.allocations.remove(allocation);
                        }
                        break;
                    }
                    case 25: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: {
                        Integer reg = RegisterUtils.getALoadReg((DismantleBytecode)this, seen);
                        Integer allocation = this.storedAllocations.get(reg);
                        if (allocation != null) {
                            AllocationInfo info = this.allocations.get(allocation);
                            if (info != null && info.loopBottom != -1) {
                                this.allocations.remove(allocation);
                                this.storedAllocations.remove(reg);
                                break;
                            }
                            sawAllocationNumber = allocation;
                            sawAllocation = true;
                        }
                        break;
                    }
                    case 181: {
                        if (this.stack.getStackDepth() <= 1) break;
                        OpcodeStack.Item item = this.stack.getStackItem(0);
                        Integer allocation = (Integer)item.getUserValue();
                        this.allocations.remove(allocation);
                        break;
                    }
                    case 176: 
                    case 191: {
                        OpcodeStack.Item item;
                        Integer allocation;
                        if (this.stack.getStackDepth() <= 0 || (allocation = (Integer)(item = this.stack.getStackItem(0)).getUserValue()) == null) break;
                        item.setUserValue(null);
                        this.allocations.remove(allocation);
                    }
                }
                Object var10_26 = null;
            }
            catch (Throwable throwable) {
                Object var10_27 = null;
                TernaryPatcher.pre(this.stack, seen);
                this.stack.sawOpcode((DismantleBytecode)this, seen);
                TernaryPatcher.post(this.stack, seen);
                if (sawAllocation) {
                    if (this.stack.getStackDepth() > 0) {
                        OpcodeStack.Item item = this.stack.getStackItem(0);
                        item.setUserValue((Object)sawAllocationNumber);
                    }
                    if (seen == 183) {
                        ++this.nextAllocationNumber;
                    }
                }
                throw throwable;
            }
            TernaryPatcher.pre(this.stack, seen);
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            TernaryPatcher.post(this.stack, seen);
            if (!sawAllocation) break block29;
            if (this.stack.getStackDepth() > 0) {
                OpcodeStack.Item item = this.stack.getStackItem(0);
                item.setUserValue((Object)sawAllocationNumber);
            }
            if (seen == 183) {
                ++this.nextAllocationNumber;
            }
        }
    }

    private boolean isFirstUse(int reg) {
        LocalVariableTable lvt = this.getMethod().getLocalVariableTable();
        if (lvt == null) {
            return true;
        }
        LocalVariable lv = lvt.getLocalVariable(reg, this.getPC());
        return lv == null;
    }

    static {
        SYNTHETIC_ALLOCATION_CLASSES.add("java/lang/StringBuffer");
        SYNTHETIC_ALLOCATION_CLASSES.add("java/lang/StringBuilder");
        SYNTHETIC_ALLOCATION_CLASSES.add("java/lang/AssertionError");
    }

    static class AllocationInfo {
        int allocationPC;
        int loopTop;
        int loopBottom;

        public AllocationInfo(int pc) {
            this.allocationPC = pc;
            this.loopTop = -1;
            this.loopBottom = -1;
        }
    }
}

