/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class PossibleIncompleteSerialization
implements Detector {
    private BugReporter bugReporter;

    public PossibleIncompleteSerialization(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            block4: {
                try {
                    JavaClass superCls;
                    JavaClass cls = classContext.getJavaClass();
                    if (!this.isSerializable(cls) || this.isSerializable(superCls = cls.getSuperClass()) || !this.hasSerializableFields(superCls) || this.hasSerializingMethods(cls)) break block4;
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "PIS_POSSIBLE_INCOMPLETE_SERIALIZATION", 2).addClass(cls));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Object var5_6 = null;
                }
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            throw throwable;
        }
    }

    private boolean isSerializable(JavaClass cls) throws ClassNotFoundException {
        JavaClass[] infs;
        for (JavaClass inf : infs = cls.getAllInterfaces()) {
            String clsName = inf.getClassName();
            if (!"java.io.Serializable".equals(clsName) && !"java.io.Externalizable".equals(clsName)) continue;
            return true;
        }
        return false;
    }

    private boolean hasSerializableFields(JavaClass cls) {
        Field[] fields;
        for (Field f : fields = cls.getFields()) {
            if (f.isStatic() || f.isTransient() || f.isSynthetic()) continue;
            return true;
        }
        return false;
    }

    private boolean hasSerializingMethods(JavaClass cls) {
        Method[] methods;
        for (Method m : methods = cls.getMethods()) {
            if (m.isStatic()) continue;
            String methodName = m.getName();
            String methodSig = m.getSignature();
            if ("writeObject".equals(methodName) && "(Ljava/io/ObjectOutputStream;)V".equals(methodSig)) {
                return true;
            }
            if (!"writeExternal".equals(methodName) || !"(Ljava/io/ObjectOutput;)V".equals(methodSig)) continue;
            return true;
        }
        return false;
    }

    public void report() {
    }
}

